/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.batch;

import com.kingdee.bos.framework.batch.IBatchExecuteResult;
import java.io.Serializable;

public final class BatchExecuteResult
implements IBatchExecuteResult,
Serializable {
    private static final long serialVersionUID = 8116398113885027745L;
    private final Object[] returnValues;
    private final Throwable[] exceptions;
    private Object batchResult;

    public BatchExecuteResult(int size) {
        assert (size > 0);
        this.returnValues = new Object[size];
        this.exceptions = new Throwable[size];
    }

    public int size() {
        return this.returnValues.length;
    }

    public Object getBatchResult() {
        return this.batchResult;
    }

    public void setBatchResult(Object batchResult) {
        this.batchResult = batchResult;
    }

    public boolean valueReturned(int index) {
        return this.getReturnValue(index) != null;
    }

    public Object getReturnValue(int index) {
        return this.returnValues[index];
    }

    public void setReturnValue(int index, Object rtv) {
        this.returnValues[index] = rtv;
    }

    @Override
    public boolean exceptionOccured(int index) {
        return this.getException(index) != null;
    }

    public Throwable getException(int index) {
        return this.exceptions[index];
    }

    public void setException(int index, Throwable ex) {
        this.exceptions[index] = ex;
    }

    public Object[] getReturnValues() {
        Object[] rv = new Object[this.returnValues.length];
        System.arraycopy(this.returnValues, 0, rv, 0, this.returnValues.length);
        return rv;
    }

    public Throwable[] getExceptions() {
        Throwable[] th = new Throwable[this.exceptions.length];
        System.arraycopy(this.exceptions, 0, th, 0, this.exceptions.length);
        return th;
    }
}

