/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.bp;

import com.kingdee.bos.framework.bp.BpException;
import com.kingdee.bos.framework.bp.BpRunner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractBpRunner
implements BpRunner {
    @Override
    public void run() {
        this.beforeRun();
        try {
            this.processResult(this.runBp());
        }
        catch (BpException e) {
            this.processException((Throwable)((Object)e));
        }
        this.endRun();
    }

    protected Object runBp() throws BpException {
        Object obj = this.getBizObject();
        Method bizMethod = this.getBizMethod();
        Object[] parmeValues = this.getParmeValues();
        this.checkMethod(bizMethod, parmeValues);
        try {
            return bizMethod.invoke(obj, parmeValues);
        }
        catch (IllegalArgumentException e) {
            throw new BpException(1, e);
        }
        catch (IllegalAccessException e) {
            throw new BpException(1, e);
        }
        catch (InvocationTargetException e) {
            throw new BpException(1, e);
        }
    }

    void checkMethod(Method bizMethod, Object[] parmeValues) throws BpException {
    }

    protected abstract void processResult(Object var1);

    protected abstract void processException(Throwable var1);

    protected abstract void endRun();

    protected abstract void beforeRun();

    protected abstract Object getBizObject();

    protected abstract Method getBizMethod();

    protected abstract Object[] getParmeValues();
}

