/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.bp;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.bp.AbstractBpRunner;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.BackgroundProcess;
import com.kingdee.bos.framework.bp.BpException;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.enactment.message.DirectSenderAgent;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BPJob
extends AbstractBpRunner {
    private static final Logger logger = Logger.getLogger(BPJob.class);
    private BackgroundProcess bp;

    public BPOption getOption() {
        return this.bp.getOption();
    }

    public int compareTo(Object o) {
        if (o instanceof BPJob) {
            BPJob job = (BPJob)o;
            return this.bp.getOption().getPriority() - job.getOption().getPriority();
        }
        return 1;
    }

    public BackgroundProcess getBp() {
        return this.bp;
    }

    public void setBp(BackgroundProcess bp) {
        this.bp = bp;
    }

    public Object runBp(BizController biz, Context context, Method bizMethod, Object[] parmeValues) throws BpException {
        this.checkMethod(bizMethod, parmeValues);
        Object[] _parmeValues = new Object[parmeValues.length + 1];
        System.arraycopy(parmeValues, 0, _parmeValues, 1, parmeValues.length);
        _parmeValues[0] = context;
        try {
            return bizMethod.invoke((Object)biz, _parmeValues);
        }
        catch (IllegalArgumentException e) {
            throw new BpException(1, e);
        }
        catch (IllegalAccessException e) {
            throw new BpException(1, e);
        }
        catch (InvocationTargetException e) {
            throw new BpException(1, e);
        }
    }

    @Override
    void checkMethod(Method bizMethod, Object[] parmeValues) throws BpException {
    }

    @Override
    protected void beforeRun() {
    }

    @Override
    protected void endRun() {
    }

    @Override
    protected Method getBizMethod() {
        return this.bp.getMth();
    }

    @Override
    protected Object getBizObject() {
        return this.bp.getBosObject();
    }

    @Override
    protected Object[] getParmeValues() {
        return this.bp.getParameters();
    }

    @Override
    protected void processException(Throwable t) {
        this.sendMessage(this.constractMessage(t, null));
    }

    @Override
    protected void processResult(Object object) {
        if (this.getOption().getMessageReceivers() != null && this.getOption().getMessageReceivers().length > 0) {
            this.sendMessage(this.constractMessage(null, object));
        }
    }

    private Message constractMessage(Throwable t, Object re) {
        Message message = MessageFactory.newMessage();
        StringBuffer body = new StringBuffer();
        String boClass = this.bp.getBosObject().getClass().getName();
        if (t != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            t.printStackTrace(new PrintWriter(out));
            body.append(out.toString());
            message.setLocaleStringHeader("title", "BackGround Process Error [" + boClass + "]", new Locale("l1"));
            message.setLocaleStringHeader("body", body.toString(), new Locale("l1"));
            message.setLocaleStringHeader("title", EASResource.getString("com.kingdee.bos.framework.BOSFramework", "8_BPJob") + boClass + "\u3011", new Locale("l2"));
            message.setLocaleStringHeader("body", body.toString(), new Locale("L2"));
            message.setLocaleStringHeader("title", EASResource.getString("com.kingdee.bos.framework.BOSFramework", "9_BPJob") + boClass + "\u3011", new Locale("l3"));
            message.setLocaleStringHeader("body", body.toString(), new Locale("L3"));
        } else {
            message.setLocaleStringHeader("title", "BackGround Process Sucess [" + boClass + "]", new Locale("l1"));
            message.setLocaleStringHeader("body", body.toString(), new Locale("l1"));
            message.setLocaleStringHeader("title", EASResource.getString("com.kingdee.bos.framework.BOSFramework", "10_BPJob") + boClass + "\u3011", new Locale("l2"));
            message.setLocaleStringHeader("body", EASResource.getString("com.kingdee.bos.framework.BOSFramework", "10_BPJob") + boClass + "\u3011", new Locale("l2"));
            message.setLocaleStringHeader("title", EASResource.getString("com.kingdee.bos.framework.BOSFramework", "11_BPJob") + boClass + "\u3011", new Locale("l3"));
            message.setLocaleStringHeader("body", EASResource.getString("com.kingdee.bos.framework.BOSFramework", "11_BPJob") + boClass + "\u3011", new Locale("l3"));
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        message.setIntHeader("priority", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setLocaleStringHeader("sender", "bpAdmin", new Locale("l1"));
        message.setLocaleStringHeader("sender", EASResource.getString("com.kingdee.bos.framework.BOSFramework", "12_BPJob"), new Locale("l2"));
        message.setLocaleStringHeader("sender", EASResource.getString("com.kingdee.bos.framework.BOSFramework", "13_BPJob"), new Locale("l3"));
        message.setStringHeader("receiver", StringUtils.arrayToString((Object[])this.getOption().getMessageReceivers(), (String)";"));
        message.setStringHeader("databaseCenter", this.getOption().getDataCenter());
        message.setStringHeader("solution", "eas");
        message.setBooleanHeader("isSendEmail", false);
        message.setBooleanHeader("isSendMobile", false);
        message.setBooleanHeader("isSendCommon", false);
        return message;
    }

    private void sendMessage(Message message) {
        DirectSenderAgent.getInstance().sendMessage(message);
    }
}

