/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.command;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.command.ICommand;
import com.kingdee.bos.framework.command.MessageSenderAdapter;
import org.apache.log4j.Logger;

public class BOSCommandRunner
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.framework.command.BOSCommandRunner");
    private final Context ctx;
    private final ICommand cmd;

    public BOSCommandRunner(Context ctx, ICommand cmd) {
        this.ctx = ctx;
        this.cmd = cmd;
    }

    @Override
    public void run() {
        try {
            this.cmd.execute(this.ctx);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SUCESS EXECUTE COMMAND " + this.cmd));
            }
            MessageSenderAdapter.sendSucessMessage(this.ctx, this.cmd);
        }
        catch (BOSException e) {
            logger.error((Object)"FAILURE EXECUTE COMMAND", (Throwable)e);
            MessageSenderAdapter.sendFailureMessage(this.ctx, this.cmd, e);
        }
    }
}

