/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.command;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.command.BOSCommandRunner;
import com.kingdee.bos.framework.command.CommandRunnerQueue;
import com.kingdee.bos.framework.command.ICommand;
import com.kingdee.bos.framework.command.ICommandExecutor;
import com.kingdee.bos.framework.command.ThreadPoolFactory;
import com.kingdee.bos.service.IServiceStateListener;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;

public class CommandExecutor
extends AbstractBOSObject
implements ICommandExecutor {
    public CommandExecutor(Context ctx) {
        super(ctx);
        this.registerInterface(ICommandExecutor.class, this);
    }

    public CommandExecutor() {
        this.registerInterface(ICommandExecutor.class, this);
    }

    @Override
    public Object asyncExecute(ICommand cmd) {
        if (cmd == null) {
            throw new NullPointerException("Parameter cmd cannot be null!");
        }
        if (!ServiceStateManager.getInstance().isEmpty()) {
            ServiceStateManager.ServiceState state = ServiceStateManager.getInstance().getServiceState();
            CommandRunnerQueue.getQueue(state.getID()).put(new BOSCommandRunner(this.getContext(), cmd));
        } else {
            ThreadPoolFactory.getInstance().run((Runnable)new BOSCommandRunner(this.getContext(), cmd));
        }
        return null;
    }

    @Override
    public Object syncExecute(ICommand cmd) throws BOSException {
        if (cmd == null) {
            throw new NullPointerException("Parameter cmd cannot be null!");
        }
        return cmd.execute(this.getContext());
    }

    public BOSObjectType getType() {
        return null;
    }

    static {
        ServiceStateManager.addStateListener((IServiceStateListener)new ServiceStateListener());
    }

    private static class ServiceStateListener
    implements IServiceStateListener {
        private ServiceStateListener() {
        }

        public void pop(ServiceStateManager.ServiceState state) {
            if (state.getLevel() == 1 && CommandRunnerQueue.contains(state.getID())) {
                CommandRunnerQueue queue = CommandRunnerQueue.getQueue(state.getID());
                BOSCommandRunner cmd = queue.get();
                while (cmd != null) {
                    ThreadPoolFactory.getInstance().run((Runnable)cmd);
                    cmd = queue.get();
                }
                CommandRunnerQueue.removeQueue(state.getID());
            }
        }

        public void push(ServiceStateManager.ServiceState state) {
        }
    }
}

