/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.command;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.command.ICommand;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.MessageSender;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public final class MessageSenderAdapter {
    private static final SendStrategy strategy;
    private static final Logger logger;

    private static void sendMsg(Message msg) {
        try {
            if (SenderAgent.getSenderAgent().getState() != 1) {
                SenderAgent.getSenderAgent().start();
            }
            MessageSender.getInstance().sendMessage(msg);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("\n@@Send jms asynchrnous notification message:\n" + msg.getStringHeader("title") + "\n personId:" + msg.getStringHeader("receiver") + "\n solution:" + msg.getStringHeader("solution") + "\n ais:" + msg.getStringHeader("databaseCenter") + "\n Exception:" + msg.getBody()));
            }
        }
        catch (Throwable ta) {
            throw new RuntimeException("Send JMS Exception", ta);
        }
    }

    public static void sendSucessMessage(Context ctx, ICommand cmd) {
        if (MessageSenderAdapter.getSendStrategy().isSucessEnabled()) {
            Message msg = MessageSenderAdapter.createMsg(ctx.getAIS(), ctx.getSolution(), "SUCESS COMMAND[" + cmd.toString() + "]", ctx.getCaller().toString(), null);
            MessageSenderAdapter.sendMsg(msg);
        }
    }

    public static void sendFailureMessage(Context ctx, ICommand cmd, BOSException e) {
        if (MessageSenderAdapter.getSendStrategy().isFailureEnabled()) {
            String body = e.getMessage();
            if (MessageSenderAdapter.getSendStrategy().isFailureStackEnabled()) {
                body = body + "\n" + MessageSenderAdapter.stack2string((Exception)((Object)e));
            }
            Message msg = MessageSenderAdapter.createMsg(ctx.getAIS(), ctx.getSolution(), "FAILURE COMMAND[" + cmd.toString() + "]", ctx.getCaller().toString(), body);
            MessageSenderAdapter.sendMsg(msg);
        }
    }

    private static Message createMsg(String ais, String solution, String title, String reciverId, String body) {
        Message msg = MessageFactory.newMessage();
        msg.setStringHeader("title", "Asynchronous Call");
        msg.setStringHeader("sender", "WFAdmin");
        msg.setDomian("kingdee.workflow");
        msg.setIntHeader("type", 0);
        msg.setIntHeader("bizType", 0);
        msg.setIntHeader("priority", 10);
        msg.setStringHeader("databaseCenter", ais);
        msg.setStringHeader("solution", solution);
        msg.setStringHeader("receiver", reciverId);
        msg.setBody(body);
        return msg;
    }

    private static SendStrategy getSendStrategy() {
        return strategy;
    }

    static String stack2string(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "------\r\n" + sw.toString() + "------\r\n";
        }
        catch (Exception e2) {
            return "bad stack2string";
        }
    }

    static {
        logger = Logger.getLogger((String)"com.kingdee.bos.framework.command.MessageSenderAdapter");
        strategy = new SendStrategy();
        try {
            String sendAsyncMsg;
            ConfigurationItem item = Configuration.getInstance().getConfigItem("DebugOptions");
            if (item != null && (sendAsyncMsg = item.getProperty("sendAsncMsg")) != null && sendAsyncMsg.equals("true")) {
                MessageSenderAdapter.strategy.isDebug = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class SendStrategy {
        boolean isDebug = false;

        private SendStrategy() {
        }

        boolean isSucessEnabled() {
            return this.isDebug;
        }

        boolean isFailureEnabled() {
            return this.isDebug;
        }

        boolean isFailureStackEnabled() {
            return this.isDebug;
        }
    }
}

