/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.ejb;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormCacheService.ORMCacheUtil;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.HistoryParam;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.ejb.AbstractBizControllerBean;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.HistoryEntityParam;
import com.kingdee.bos.framework.ejb.HistoryObjectCreator;
import com.kingdee.bos.framework.ejb.HistoryObjectUpdater;
import com.kingdee.bos.framework.ejb.HistoryUpdateResultParam;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractEntityControllerBean
extends AbstractBizControllerBean {
    protected static final String METHODNAME_GETVALUE = "getValue";
    public static final Logger logger = Logger.getLogger(AbstractEntityControllerBean.class);

    protected final IORMappingDAO getDAO(Context ctx, Connection cn) throws BOSException {
        if (this instanceof ICommonBOSType) {
            return ORMappingDAO.getInstance(this.getBOSType(), ctx, cn, ((ICommonBOSType)this).getPK());
        }
        return ORMappingDAO.getInstance(this.getBOSType(), ctx, cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean innerExists(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn;
        block4: {
            boolean bl;
            cn = null;
            try {
                if (!this.needCache(ctx)) break block4;
                Object val = ORMCacheUtil.getInstance().getInfo(ctx, this.getBOSType(), pk, "EXIST");
                if (val == null) {
                    cn = this.getConnection(ctx);
                    boolean isExist = this.getDAO(ctx, cn).exists(pk);
                    val = isExist;
                    ORMCacheUtil.getInstance().putInfo(ctx, this.getBOSType(), pk, "EXIST", val);
                }
                bl = (Boolean)val;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)cn);
            return bl;
        }
        cn = this.getConnection(ctx);
        boolean bl = this.getDAO(ctx, cn).exists(pk);
        SQLUtils.cleanup((Connection)cn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean innerExists(Context ctx, FilterInfo filter) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean bl = this.getDAO(ctx, cn).exists(filter);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean innerExists(Context ctx, String oql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean bl = this.getDAO(ctx, cn).exists(oql);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private void checkPK(IObjectPK pk) {
        if (pk == null) {
            throw new IllegalArgumentException("pk can  not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectValue innerGetValue(Context ctx, String oql) throws BOSException {
        EntityViewInfo view;
        Connection cn;
        block6: {
            IObjectValue iObjectValue;
            cn = null;
            try {
                view = null;
                Object[] params = new Object[]{oql};
                try {
                    view = new EntityViewInfo(oql);
                }
                catch (ParserException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage());
                }
                this.innerHandleParamEntityView(ctx, null, view, METHODNAME_GETVALUE, params, false);
                if (!this.needCache(ctx)) break block6;
                String viewEncode = view.encode();
                Object val = ORMCacheUtil.getInstance().getInfo(ctx, this.getBOSType(), viewEncode);
                if (val == null) {
                    cn = this.getConnection(ctx);
                    val = this.getDAO(ctx, cn).getValue(view);
                    ORMCacheUtil.getInstance().putInfo(ctx, this.getBOSType(), viewEncode, (IObjectValue)val);
                }
                iObjectValue = (IObjectValue)val;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)cn);
            return iObjectValue;
        }
        cn = this.getConnection(ctx);
        IObjectValue iObjectValue = this.getDAO(ctx, cn).getValue(view);
        SQLUtils.cleanup((Connection)cn);
        return iObjectValue;
    }

    protected final IObjectValue innerGetValue(Context ctx, IObjectPK pk) throws BOSException {
        this.checkPK(pk);
        EntityViewInfo view = new EntityViewInfo();
        Object[] params = new Object[]{pk};
        this.innerHandleParamEntityView(ctx, pk, view, METHODNAME_GETVALUE, params, true);
        return this.getCachedValue(ctx, this.getBOSType(), pk, view);
    }

    protected final IObjectValue innerGetValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException {
        this.checkPK(pk);
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selector);
        Object[] params = new Object[]{pk, selector};
        this.innerHandleParamEntityView(ctx, pk, view, METHODNAME_GETVALUE, params, false);
        return this.getCachedValue(ctx, this.getBOSType(), pk, view);
    }

    protected final IObjectValue innerGetValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException {
        this.checkPK(pk);
        EntityViewInfo view = new EntityViewInfo();
        view.setSorter(sorter);
        Object[] params = new Object[]{pk, sorter};
        this.innerHandleParamEntityView(ctx, pk, view, METHODNAME_GETVALUE, params, false);
        return this.getCachedValue(ctx, this.getBOSType(), pk, view);
    }

    protected final IObjectValue innerGetValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException {
        this.checkPK(pk);
        EntityViewInfo view = new EntityViewInfo();
        view.setSorter(sorter);
        view.setSelector(selector);
        Object[] params = new Object[]{pk, selector, sorter};
        this.innerHandleParamEntityView(ctx, pk, view, METHODNAME_GETVALUE, params, false);
        return this.getCachedValue(ctx, this.getBOSType(), pk, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue getCachedValue(Context ctx, BOSObjectType bosType, IObjectPK pk, EntityViewInfo view) throws BOSException {
        Connection cn;
        block7: {
            Object val;
            block9: {
                block8: {
                    IObjectValue iObjectValue;
                    cn = null;
                    try {
                        if (!this.needCache(ctx)) break block7;
                        String viewEncode = view.encode();
                        val = ORMCacheUtil.getInstance().getInfo(ctx, this.getBOSType(), pk, viewEncode);
                        if (val != null) break block8;
                        try {
                            cn = this.getConnection(ctx);
                            val = this.getDAO(ctx, cn).getValue(view);
                            ORMValueCacheService.getInstance().put(ctx, this.getBOSType(), pk, viewEncode, (IObjectValue)val);
                        }
                        catch (ObjectNotFoundException ote) {
                            ORMCacheUtil.getInstance().putInfo(ctx, this.getBOSType(), pk, viewEncode, "null");
                        }
                        iObjectValue = (IObjectValue)val;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(cn);
                        throw throwable;
                    }
                    SQLUtils.cleanup((Connection)cn);
                    return iObjectValue;
                }
                if (!(val instanceof String)) break block9;
                IObjectValue iObjectValue = null;
                SQLUtils.cleanup((Connection)cn);
                return iObjectValue;
            }
            IObjectValue iObjectValue = (IObjectValue)val;
            SQLUtils.cleanup((Connection)cn);
            return iObjectValue;
        }
        cn = this.getConnection(ctx);
        IObjectValue iObjectValue = this.getDAO(ctx, cn).getValue(view);
        SQLUtils.cleanup((Connection)cn);
        return iObjectValue;
    }

    protected void innerHandleParamEntityView(Context ctx, IObjectPK pk, EntityViewInfo view, String MethodName, Object[] params, boolean isSetDefaultSelector) throws BOSException {
        String key;
        EntityViewInfo vInfo;
        if (pk != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo bo = null;
            bo = this instanceof ICommonBOSType && ((ICommonBOSType)this).getPK() != null ? loader.getEntity(((ICommonBOSType)this).getPK()) : loader.getEntity(this.getBOSType());
            FilterInfo filterData = ImplUtils.createFilter(bo, pk);
            view.setFilter(filterData);
            if (isSetDefaultSelector && bo.getDefaultView() != null) {
                SelectorItemCollection selector = bo.getDefaultView().getSelector();
                view.setSelector(selector);
            }
        }
        if ((vInfo = this.getPermissionViewInfo(ctx, key = ImplUtils.buildPermissionServiceKey(this.getBOSType(), METHODNAME_GETVALUE, params))) != null) {
            view.getFilter().mergeFilter(vInfo.getFilter(), "and");
            view.getEntryFilters().addObjectCollection((IObjectCollection)vInfo.getEntryFilters());
            boolean flag = true;
            int n = view.getEntryFilters().size();
            for (int i = 0; i < n; ++i) {
                FilterInfo filter = view.getEntryFilters().get(i);
                EntryFilterType type = filter.getEntryFilterType();
                if (EntryFilterType.NORMAL.equals((Object)type)) continue;
                flag = false;
                break;
            }
            view.setEntryPermCol(flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectPK innerAddnew(Context ctx, IObjectValue model) throws BOSException {
        IObjectPK iObjectPK;
        Connection cn = null;
        try {
            if (this.needCache(ctx)) {
                ORMCacheUtil.getInstance().removeAllCollection(ctx, this.getBOSType());
            }
            cn = this.getConnection(ctx);
            HistoryParam hisParam = HistoryUtil.getHistoryParam(model);
            IObjectPK pk = this.getDAO(ctx, cn).addnew(model);
            if (this.needCache(ctx)) {
                ORMCacheUtil.getInstance().putInfo(ctx, this.getBOSType(), pk, "EXIST", true);
            }
            if (HistoryUtil.needHistory(ctx, model.getBOSType())) {
                model.put(HistoryConstant.ID, (Object)BOSUuid.read((String)pk.toString()));
                HistoryObjectCreator objectCreator = new HistoryObjectCreator();
                objectCreator.innerAddnew(ctx, cn, model, hisParam);
            }
            iObjectPK = pk;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
        return iObjectPK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void innerAddnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        Connection cn = null;
        try {
            if (this.needCache(ctx)) {
                ORMCacheUtil.getInstance().removeAllCollection(ctx, this.getBOSType());
            }
            cn = this.getConnection(ctx);
            this.getDAO(ctx, cn).addnew(pk, model);
            if (this.needCache(ctx)) {
                ORMCacheUtil.getInstance().putInfo(ctx, this.getBOSType(), pk, "EXIST", true);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void innerUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        Connection cn = null;
        try {
            if (this.needCache(ctx)) {
                ORMValueCacheService.getInstance().remove(ctx, this.getBOSType(), pk);
            }
            cn = this.getConnection(ctx);
            HistoryUtil.cleanInfo(ctx, model);
            HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, model.getBOSType());
            if (param.isNeedHistory() && model.get(HistoryConstant.EFFDT) == null) {
                model.put(HistoryConstant.EFFDT, (Object)DateTimeUtils.truncateDate((Date)new Date()));
            }
            this.getDAO(ctx, cn).update(pk, model);
            HistoryParam hisParam = HistoryUtil.getHistoryParam(model);
            HistoryObjectUpdater hisObjectUpdater = new HistoryObjectUpdater();
            HistoryUpdateResultParam result = hisObjectUpdater.innerUpdateModify(ctx, cn, pk, model, hisParam);
            if (this.needCache(ctx) && result.getPks().length > 0) {
                ORMValueCacheService.getInstance().removeBatch(ctx, BOSUuid.read((String)result.getPks()[0].toString()).getType(), result.getPks());
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectPK innerAddNewHistoryOnly(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectValue model = this.innerGetValue(ctx, pk);
            HistoryUtil.cleanInfo(ctx, model);
            HistoryParam hisParam = HistoryUtil.getHistoryParam(model);
            HistoryObjectCreator hisObjectCreator = new HistoryObjectCreator();
            IObjectPK hispk = hisObjectCreator.innerAddnew(ctx, cn, model, hisParam);
            if (this.needCache(ctx) && hispk != null) {
                ORMValueCacheService.getInstance().remove(ctx, BOSUuid.read((String)hispk.toString()).getType(), hispk);
            }
            IObjectPK iObjectPK = hispk;
            return iObjectPK;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectPK innerUpdateHistoryOnly(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectValue model = this.innerGetValue(ctx, pk);
            HistoryParam hisParam = HistoryUtil.getHistoryParam(model);
            HistoryObjectUpdater hisObjectUpdater = new HistoryObjectUpdater();
            HistoryUpdateResultParam result = hisObjectUpdater.innerUpdateModify(ctx, cn, pk, model, hisParam);
            if (this.needCache(ctx) && result.getPks().length > 0) {
                ORMValueCacheService.getInstance().removeBatch(ctx, BOSUuid.read((String)result.getPks()[0].toString()).getType(), result.getPks());
            }
            IObjectPK iObjectPK = result.getHistoryPK();
            return iObjectPK;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectPK innerReviseHistoryOnly(Context ctx, IObjectPK pk, BOSObjectType type) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectValue model = this.innerGetValue(ctx, pk);
            HistoryParam hisParam = HistoryUtil.getHistoryParam(model);
            HistoryObjectUpdater hisObjectUpdater = new HistoryObjectUpdater();
            HistoryUpdateResultParam result = hisObjectUpdater.innerUpdateModifyHistoryRevise(ctx, cn, pk, model, hisParam);
            if (this.needCache(ctx) && result.getPks().length > 0) {
                ORMValueCacheService.getInstance().removeBatch(ctx, BOSUuid.read((String)result.getPks()[0].toString()).getType(), result.getPks());
            }
            IObjectPK iObjectPK = result.getHistoryPK();
            return iObjectPK;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void innerUpdateBigObject(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        Connection cn = null;
        try {
            if (this.needCache(ctx)) {
                ORMValueCacheService.getInstance().remove(ctx, this.getBOSType(), pk);
            }
            cn = this.getConnection(ctx);
            this.getDAO(ctx, cn).updateBigObject(pk, model);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void innerUpdatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException {
        Connection cn = null;
        try {
            if (this.needCache(ctx)) {
                ORMValueCacheService.getInstance().remove(ctx, this.getBOSType(), model.getString("id"));
            }
            cn = this.getConnection(ctx);
            HistoryParam hisParam = HistoryUtil.getHistoryParam(model);
            HistoryUtil.cleanInfo(ctx, model);
            HistoryEntityParam param = HistoryUtil.getHistoryEntityParam(ctx, model.getBOSType());
            if (param.isNeedHistory()) {
                if (model.get(HistoryConstant.EFFDT) == null) {
                    model.put(HistoryConstant.EFFDT, (Object)DateTimeUtils.truncateDate((Date)new Date()));
                }
                selector.add(new SelectorItemInfo(HistoryConstant.EFFDT));
            }
            this.getDAO(ctx, cn).updatePartial(model, selector);
            HistoryObjectUpdater hisObjectUpdater = new HistoryObjectUpdater();
            HistoryUpdateResultParam result = hisObjectUpdater.innerUpdateModify(ctx, cn, (IObjectPK)new ObjectUuidPK(model.get(HistoryConstant.ID).toString()), model, hisParam);
            if (this.needCache(ctx) && result.getPks().length > 0) {
                ORMValueCacheService.getInstance().removeBatch(ctx, BOSUuid.read((String)result.getPks()[0].toString()).getType(), result.getPks());
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void innerDelete(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            this.canDelete(ctx, pk, cn);
            if (this.needCache(ctx)) {
                ORMValueCacheService.getInstance().remove(ctx, this.getBOSType(), pk);
            }
            this.getDAO(ctx, cn).delete(pk);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectPK[] innerDelete(Context ctx, FilterInfo filter) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] pks = this.getDAO(ctx, cn).delete(filter);
            if (this.needCache(ctx)) {
                ORMValueCacheService.getInstance().removeBatch(ctx, this.getBOSType(), pks);
            }
            IObjectPK[] iObjectPKArray = pks;
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectPK[] innerDelete(Context ctx, String oql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] pks = this.getDAO(ctx, cn).delete(oql);
            if (this.needCache(ctx)) {
                ORMValueCacheService.getInstance().removeBatch(ctx, this.getBOSType(), pks);
            }
            IObjectPK[] iObjectPKArray = pks;
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void innerDelete(Context ctx, IObjectPK[] arrayPK) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            if (this.needCache(ctx)) {
                ORMValueCacheService.getInstance().removeBatch(ctx, this.getBOSType(), arrayPK);
            }
            this.getDAO(ctx, cn).delete(arrayPK);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectPK[] innerGetPKList(Context ctx) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] iObjectPKArray = this.getDAO(ctx, cn).getPKList();
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectPK[] innerGetPKList(Context ctx, String oql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] iObjectPKArray = this.getDAO(ctx, cn).getPKList(oql);
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectPK[] innerGetPKList(Context ctx, FilterInfo filter, SorterItemCollection sorter) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectPK[] iObjectPKArray = this.getDAO(ctx, cn).getPKList(filter, sorter);
            return iObjectPKArray;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected final IObjectCollection innerGetCollection(Context ctx, IServiceContext svCtx) throws BOSException {
        return this.innerGetCollection(ctx, svCtx, (EntityViewInfo)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectCollection innerGetCollection(Context ctx, IServiceContext svCtx, EntityViewInfo view) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            FilterInfo filter = (FilterInfo)svCtx.getServiceResult("PERMISSION_SERVICE");
            FilterCollection fc = (FilterCollection)svCtx.getServiceResult("PERMISSION_ENTRYS_SERVICE");
            if (view == null) {
                view = new EntityViewInfo();
            }
            if (filter != null) {
                if (view.getFilter() == null) {
                    view.setFilter(filter);
                } else {
                    view.getFilter().mergeFilter(filter, "and");
                }
            }
            if (fc != null) {
                if (view.getEntryFilters().size() == 0) {
                    view.getEntryFilters().addObjectCollection((IObjectCollection)fc);
                } else {
                    view.getEntryFilters().merge(fc, "and");
                }
            }
            if (this.needCache(ctx)) {
                String viewEncode = view.encode();
                Object val = ORMCacheUtil.getInstance().getCollection(ctx, this.getBOSType(), viewEncode);
                if (val == null) {
                    val = this.getDAO(ctx, cn).getCollection(view);
                    ORMCacheUtil.getInstance().putCollection(ctx, this.getBOSType(), viewEncode, val);
                }
                IObjectCollection iObjectCollection = (IObjectCollection)val;
                return iObjectCollection;
            }
            IObjectCollection iObjectCollection = this.getDAO(ctx, cn).getCollection(view);
            return iObjectCollection;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected final IObjectCollection innerGetCollection(Context ctx, IServiceContext svCtx, String oql) throws BOSException {
        EntityViewInfo view;
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return this.innerGetCollection(ctx, svCtx, view);
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
    }

    protected boolean needCache(Context ctx) {
        ICacheConfig config = CacheConfigManager.getConfig();
        return ctx != null && config != null && config.needServerCache() && config.needCache(this.getBOSType());
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
    }

    private final void canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        this._isReferenced(ctx, pk, cn);
        this._canDelete(ctx, pk, cn);
    }

    @Override
    protected ServiceContext createServiceContext(MetaDataPK methodPK, Object[] params) {
        return new ServiceContext(MetaDataTypeList.ENTITY, this.getBOSType(), (IMetaDataPK)methodPK, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectCollection innerGetCollection(Context ctx) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectCollection iObjectCollection = this.getDAO(ctx, cn).getCollection();
            return iObjectCollection;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectCollection innerGetCollection(Context ctx, EntityViewInfo view) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectCollection iObjectCollection = this.getDAO(ctx, cn).getCollection(view);
            return iObjectCollection;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IObjectCollection innerGetCollection(Context ctx, String oql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IObjectCollection iObjectCollection = this.getDAO(ctx, cn).getCollection(oql);
            return iObjectCollection;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private EntityViewInfo getPermissionViewInfo(Context ctx, String key) throws BOSException {
        EntityViewInfo view = null;
        Object permissionSrvRtn = ctx.get((Object)key);
        if (permissionSrvRtn != null) {
            if (permissionSrvRtn instanceof EntityViewInfo) {
                view = (EntityViewInfo)permissionSrvRtn;
            } else {
                logger.error((Object)("Illegal Object type error, expected: <EntityViewInfo>, but was : <" + permissionSrvRtn.getClass().getName() + ">"));
            }
            ctx.remove((Object)key);
        }
        return view;
    }

    /*
     * Loose catch block
     */
    private String idArray2TempTableFilter(EntityViewInfo view, Context ctx) throws BOSException {
        if (view == null || view.getFilter() == null || view.getFilter().getFilterItems().isEmpty()) {
            return null;
        }
        String idTmpTable = null;
        FilterItemCollection filterItems = view.getFilter().getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            Object v;
            Set values;
            FilterItemInfo item = filterItems.get(i);
            if (item.getCompareType() != CompareType.INCLUDE || !(item.getCompareValue() instanceof Set) || (values = (Set)item.getCompareValue()).size() <= 100) continue;
            Iterator it = values.iterator();
            BOSUuid id = null;
            if (it.hasNext() && (v = it.next()) != null) {
                try {
                    id = BOSUuid.read((String)v.toString());
                }
                catch (Exception ex) {
                    logger.info((Object)"not BOSUuid!");
                }
            }
            if (id == null) continue;
            Connection cn = null;
            PreparedStatement st = null;
            try {
                idTmpTable = TempTablePool.getInstance(ctx).createTempTable("create table t_virtualModeDataAccess(fid varchar(44))");
                cn = EJBFactory.getConnection(ctx);
                st = cn.prepareStatement("insert into " + idTmpTable + " values(?)");
                st.setString(1, id.toString());
                st.addBatch();
                while (it.hasNext()) {
                    st.setString(1, it.next().toString());
                    st.addBatch();
                }
                st.executeBatch();
                item.setCompareType(CompareType.INNER);
                item.setCompareValue((Object)("select fid from " + idTmpTable));
            }
            catch (UuidException ex) {
                logger.info((Object)"not bosuuid!");
                SQLUtils.cleanup(st, (Connection)cn);
                break;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(st, cn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)st, (Connection)cn);
            break;
        }
        return idTmpTable;
    }
}

