/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.ejb;

import com.kingdee.bos.framework.ejb.DBConnMonitor;
import com.kingdee.bos.framework.ejb.IEJBUtils;
import java.security.AccessControlException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class EJBUtils
implements IEJBUtils {
    protected DataSource ds;
    protected InitialContext ctx;
    private final String dataSource;
    private final String jndiUrl;
    private final String contextFactory;
    private final String securityCredential;
    private final String securityPrincipal;
    private static Logger logger = Logger.getLogger(EJBUtils.class);
    public static final HashSet connMonitorSet = new HashSet();

    public static void addConnMonitor(DBConnMonitor monitor) {
        connMonitorSet.add(monitor);
    }

    public static void removeConnMonitor(DBConnMonitor monitor) {
        connMonitorSet.remove(monitor);
    }

    public EJBUtils(String dataSource) {
        this(dataSource, null, null, null, null);
    }

    public EJBUtils(String dataSource, String jndiUrl) {
        this(dataSource, jndiUrl, null, null, null);
    }

    public EJBUtils(String dataSource, String jndiUrl, String contextFactory) {
        this(dataSource, jndiUrl, contextFactory, null, null);
    }

    public EJBUtils(String dataSource, String jndiUrl, String contextFactory, String securityCredential, String securityPrincipal) {
        this.dataSource = dataSource;
        this.contextFactory = contextFactory;
        this.jndiUrl = jndiUrl;
        this.securityCredential = securityCredential;
        this.securityPrincipal = securityPrincipal;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureDataSource();
        try {
            Connection conn = this.ds.getConnection();
            return conn;
        }
        catch (SQLException sqle) {
            this.clean();
            this.ensureDataSource();
            Connection conn = this.ds.getConnection();
            return conn;
        }
    }

    @Override
    public InitialContext getInitialContext() throws NamingException {
        if (this.ctx == null) {
            if (this.jndiUrl == null) {
                this.ctx = new InitialContext();
            } else {
                Hashtable<String, String> env = new Hashtable<String, String>();
                if (this.jndiUrl != null) {
                    env.put("java.naming.provider.url", this.jndiUrl);
                }
                if (this.contextFactory != null) {
                    env.put("java.naming.factory.initial", this.contextFactory);
                }
                if (this.securityCredential != null) {
                    env.put("java.naming.security.credentials", this.securityCredential);
                }
                if (this.securityPrincipal != null) {
                    env.put("java.naming.security.principal", this.securityPrincipal);
                }
                this.ctx = new InitialContext(env);
            }
        }
        return this.ctx;
    }

    public final void ensureDataSource() throws SQLException {
        if (this.ds == null) {
            try {
                this.ds = (DataSource)this.getInitialContext().lookup(this.dataSource);
            }
            catch (NameNotFoundException nne) {
                logger.fatal((Object)("FATAL: No DataSource is registered under the name " + this.dataSource + ", please check your datasource properties  and deployment tool.\n"), (Throwable)nne);
                throw new SQLException(nne.getMessage());
            }
            catch (NamingException nex) {
                logger.fatal((Object)"FATAL: JNDI Exception Occurred. Is your JNDI resource available?\n", (Throwable)nex);
                throw new SQLException(nex.getMessage());
            }
            catch (AccessControlException ae) {
                logger.fatal((Object)"FATAL: You cannot execute this eunction with the security permissions you are using. Try using the securityCredential/securityPrincipalpoolman parameters.\n", (Throwable)ae);
                throw new SQLException(ae.getMessage());
            }
        }
    }

    @Override
    public final String getDataSource() {
        return this.dataSource;
    }

    protected void clean() {
        this.ctx = null;
        this.ds = null;
    }
}

