/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.listener;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.listener.IMExtendListener;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IMExtendListenerManager {
    private static Logger logger = Logger.getLogger(IMExtendListenerManager.class);
    private static Map listeners = Collections.synchronizedMap(new HashMap());

    private static void init() {
        String fileName = System.getProperty("bos.config", "bosconfig.xml");
        if (!new File(fileName).exists()) {
            logger.warn((Object)(fileName + " not exist!"));
            return;
        }
        Configuration config = Configuration.getInstance();
        ConfigurationItem ci = config.getConfigItem("IMExtendListeners");
        IMExtendListenerManager.processConfigItem(ci);
    }

    private static void processConfigItem(ConfigurationItem ci) {
        if (ci == null) {
            return;
        }
        Map map = ci.getProperties();
        for (Map.Entry entry : map.entrySet()) {
            String value = (String)entry.getValue();
            try {
                Class<?> c = Class.forName(value);
                IMExtendListener listener = (IMExtendListener)c.newInstance();
                listeners.put((String)entry.getKey(), listener);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void register(String key, IMExtendListener listener) {
        listeners.put(key, listener);
    }

    public static void unregister(String key) {
        listeners.remove(key);
    }

    public static void register(String key, String className) {
        try {
            Class<?> c = Class.forName(className);
            IMExtendListener listener = (IMExtendListener)c.newInstance();
            listeners.put(key, listener);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static List getF7ExtendMenu(Context ctx, String f7Ids) {
        return IMExtendListenerManager.getF7ExtendMenu(ctx, f7Ids, "common");
    }

    public static List getF7ExtendMenu(Context ctx, String f7Ids, String regionNum) {
        Object obj = listeners.get(regionNum);
        if (obj == null) {
            return null;
        }
        if (obj instanceof IMExtendListener) {
            IMExtendListener listener = (IMExtendListener)obj;
            return listener.getF7ExtendMenu(ctx, f7Ids);
        }
        return null;
    }

    public static String[] getIMIcon(Context ctx, String f7Ids) {
        return IMExtendListenerManager.getIMIcon(ctx, f7Ids, "common");
    }

    public static String[] getIMIcon(Context ctx, String f7Ids, String regionNum) {
        Object obj = listeners.get(regionNum);
        if (obj == null) {
            return null;
        }
        if (obj instanceof IMExtendListener) {
            IMExtendListener listener = (IMExtendListener)obj;
            return listener.getIMIcon(ctx, f7Ids);
        }
        return null;
    }

    public static String getUsernamesByPersonid(Context ctx, String personid) {
        return IMExtendListenerManager.getUsernamesByPersonid(ctx, personid, "common");
    }

    public static String getUsernamesByPersonid(Context ctx, String personid, String regionNum) {
        Object obj = listeners.get(regionNum);
        if (obj == null) {
            return null;
        }
        if (obj instanceof IMExtendListener) {
            IMExtendListener listener = (IMExtendListener)obj;
            return listener.getUsernamesByPersonid(ctx, personid);
        }
        return null;
    }

    public static String[] getIMInfo(Context ctx) {
        return IMExtendListenerManager.getIMInfo(ctx, "common");
    }

    public static String[] getIMInfo(Context ctx, String regionNum) {
        Object obj = listeners.get(regionNum);
        if (obj == null) {
            return null;
        }
        if (obj instanceof IMExtendListener) {
            IMExtendListener listener = (IMExtendListener)obj;
            return listener.getIMInfo(ctx);
        }
        return null;
    }

    static {
        try {
            IMExtendListenerManager.init();
        }
        catch (Exception e) {
            logger.warn((Object)e, (Throwable)e);
        }
    }
}

