/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.function;

import com.kingdee.bos.rpc.ThreadListener;
import com.kingdee.bos.rpc.ThreadListenerManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class WfEventListenerStateManager {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.function.WfEventListenerStateManager");
    private static final ThreadLocal stateContainer = new ThreadLocal();
    private boolean isEnable = true;
    private List<String> bizCallMethods = new ArrayList<String>();

    private WfEventListenerStateManager() {
    }

    public static WfEventListenerStateManager getInstance() {
        Object o = stateContainer.get();
        if (o == null) {
            WfEventListenerStateManager manager = new WfEventListenerStateManager();
            stateContainer.set(manager);
            return manager;
        }
        return (WfEventListenerStateManager)o;
    }

    public void disableEventListener() {
        this.isEnable = false;
        this.record(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)"WfEventListenerStateManager.disableEventListener");
        }
    }

    public static void setNewStateManager() {
        WfEventListenerStateManager manager = new WfEventListenerStateManager();
        stateContainer.set(manager);
    }

    public void enableEventListener() {
        this.isEnable = true;
        this.record(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"WfEventListenerStateManager.enableEventListener");
        }
    }

    private void record(boolean enable) {
        try {
            StackTraceElement[] traces = Thread.currentThread().getStackTrace();
            StackTraceElement bizMethodStack = traces[3];
            String bizMehtod = (enable ? "Enable," : "Disable,") + bizMethodStack.getClassName() + "." + bizMethodStack.getMethodName() + ",line:" + bizMethodStack.getLineNumber();
            this.bizCallMethods.add(bizMehtod);
        }
        catch (Throwable e) {
            log.error((Object)"unbelievable", e);
        }
    }

    public String getBizCallMethods() {
        StringBuilder sb = new StringBuilder();
        for (String bizCallMethod : this.bizCallMethods) {
            sb.append(bizCallMethod).append("\n");
        }
        return sb.toString();
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    static {
        ThreadListenerManager.addListener((ThreadListener)new ThreadListener(){

            public void threadStarted(Thread thread) {
            }

            public void threadRecycled(Thread thread) {
            }

            public void threadFinished(Thread thread) {
                stateContainer.set(null);
            }

            public void threadRemoved(Thread thread) {
            }
        });
    }
}

