/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service;

import com.kingdee.bos.service.ICommonServiceManager;
import com.kingdee.bos.service.ServiceManagerAdapter;
import com.kingdee.bos.service.ServiceRef;
import java.util.List;
import org.apache.log4j.Logger;

public class CommonServiceManager {
    private static final Logger logger = Logger.getLogger(CommonServiceManager.class);
    private static volatile CommonServiceManager instance = null;
    private ServiceManagerAdapter adapter = ServiceManagerAdapter.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommonServiceManager getInstance() {
        if (instance != null) return instance;
        Class<CommonServiceManager> clazz = CommonServiceManager.class;
        synchronized (CommonServiceManager.class) {
            CommonServiceManager i = new CommonServiceManager();
            try {
                i.init();
                instance = i;
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            return instance;
        }
    }

    private CommonServiceManager() {
    }

    public void init() throws Exception {
        this.adapter.load();
    }

    public boolean isInited() {
        return true;
    }

    public boolean regiser(String content, String type) throws Exception {
        ICommonServiceManager manager = this.adapter.getServiceManager(type);
        if (manager == null) {
            throw new Exception("Can't find Service Manager of type:" + type + ",Please reigseter first");
        }
        ServiceRef ref = manager.regiser(content);
        return ref != null;
    }

    public boolean unregister(ServiceRef ref) throws Exception {
        String type = ref.getType();
        ICommonServiceManager manager = this.adapter.getServiceManager(type);
        if (manager == null) {
            throw new Exception("Can't find Service Manager of type:" + type + ",Please reigseter first");
        }
        return manager.unregister(ref.getPath(), ref.getName());
    }

    public List list(String type) {
        ICommonServiceManager manager = this.adapter.getServiceManager(type);
        if (manager == null) {
            return null;
        }
        List list = manager.listRef();
        for (int i = 0; i < list.size(); ++i) {
            ServiceRef ref = (ServiceRef)list.get(i);
            ref.setType(type);
        }
        return list;
    }

    public ServiceRef findService(String type, String path, String name) {
        ICommonServiceManager manager = this.adapter.getServiceManager(type);
        if (manager == null) {
            logger.error((Object)("Can't find Service Manager of type:" + type + ",Please reigseter first"));
        }
        ServiceRef ref = manager.getServiceRef(path, name);
        ref.setType(type);
        return ref;
    }

    public ServiceRef findService(String uri) {
        try {
            int sPos = 0;
            int ePos = 0;
            ePos = uri.indexOf("://");
            String type = uri.substring(sPos, ePos);
            sPos = ePos + "://".length();
            ePos = uri.indexOf(":", sPos);
            String path = uri.substring(sPos, ePos);
            sPos = ePos + ":".length();
            String name = uri.substring(sPos);
            return this.findService(type, path, name);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public Object execute(String type, String path, String name, Object[] values) throws Exception {
        ICommonServiceManager manager = this.adapter.getServiceManager(type);
        if (manager == null) {
            throw new Exception("Can't find service manager of type :" + type);
        }
        return manager.execute(path, name, values);
    }

    public Object execute(ServiceRef ref, Object[] values) throws Exception {
        return this.execute(ref.getType(), ref.getPath(), ref.getName(), values);
    }

    public void storeServices() {
        this.adapter.storeServices();
    }

    protected void finalize() throws Throwable {
        this.storeServices();
    }
}

