/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.manager;

import com.kingdee.bos.service.ICommonServiceManager;
import com.kingdee.bos.service.ServiceParam;
import com.kingdee.bos.service.ServiceRef;
import com.kingdee.bos.service.ServiceUtil;
import com.kingdee.bos.service.manager.JavaService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class JavaServiceManager
implements ICommonServiceManager {
    private static final Logger logger = Logger.getLogger(JavaServiceManager.class);
    private Map services = new HashMap();
    private Map proxyCash = new HashMap();
    private static final String store_file = "JavaServiceStore.xml";

    @Override
    public void destory() {
        try {
            this.store();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    public Object execute(String path, String name, Object[] values) throws Exception {
        JavaService service = (JavaService)this.services.get(path + ":" + name);
        if (service == null) {
            throw new NullPointerException("can't find service, path:" + path + ", name:" + name);
        }
        Class proxy = service.getProxycls();
        Object proxyInstance = this.proxyCash.get(proxy);
        if (proxyInstance == null) {
            proxyInstance = proxy.newInstance();
            this.proxyCash.put(proxy, proxyInstance);
        }
        Class[] claz = null;
        List params = service.getParams();
        if (params != null && !params.isEmpty()) {
            claz = new Class[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                ServiceParam param = (ServiceParam)params.get(i);
                claz[i] = ServiceUtil.getParamClz(param);
            }
        }
        Method method = proxy.getMethod(service.getMethodname(), claz);
        Object result = method.invoke(proxyInstance, values);
        return result;
    }

    @Override
    public boolean exists(String path, String name) {
        return this.services.get(path + ":" + name) != null;
    }

    @Override
    public void init() {
        try {
            this.load();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    public ServiceRef regiser(String content) throws Exception {
        return null;
    }

    @Override
    public boolean unregister(String path, String name) throws Exception {
        return false;
    }

    @Override
    public boolean valid(String path, String name) {
        return this.exists(path, name);
    }

    public void load() throws Exception {
        URL url = this.getClass().getClassLoader().getResource(store_file);
        if (url == null) {
            url = ClassLoader.getSystemResource(store_file);
        }
        if (url == null) {
            logger.warn((Object)"can't load registered service manager. can't find file:JavaServiceStore.xml");
            return;
        }
        SAXBuilder builder = new SAXBuilder();
        Element root = builder.build(url.getFile()).getRootElement();
        List managerEls = root.getChildren("service");
        for (Element serviceEl : managerEls) {
            Element methodEl;
            String name = serviceEl.getAttributeValue("name");
            String path = serviceEl.getAttributeValue("path");
            if (this.empty(name)) {
                logger.error((Object)("XML Elemenet invalid, service name is emtpy, the element is:" + serviceEl));
                continue;
            }
            Element proxyEl = serviceEl.getChild("proxy");
            if (proxyEl == null) {
                logger.error((Object)("XML Element invalid, serive's proxy class is emtpy, the element is:" + serviceEl));
                continue;
            }
            JavaService service = new JavaService();
            String proxycls = proxyEl.getTextTrim();
            try {
                service.setProxycls(Class.forName(proxycls));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            service.setName(name);
            service.setPath(path);
            Element descEl = serviceEl.getChild("description");
            if (descEl != null) {
                service.setDescription(descEl.getTextTrim());
            }
            if ((methodEl = serviceEl.getChild("method")) == null || methodEl.getAttributeValue("name") == null) {
                logger.error((Object)("XML Elemenet invalid, serivce's method is empty, the element is:" + serviceEl));
                continue;
            }
            service.setMethodname(methodEl.getAttributeValue("name"));
            boolean valid = true;
            ArrayList<ServiceParam> params = null;
            List paramEls = methodEl.getChildren("param");
            if (paramEls != null) {
                params = new ArrayList<ServiceParam>();
                for (int pi = 0; pi < paramEls.size(); ++pi) {
                    Element paramEl = (Element)paramEls.get(pi);
                    String pName = paramEl.getAttributeValue("name");
                    String pcls = paramEl.getAttributeValue("class");
                    if (this.empty(pcls)) {
                        logger.error((Object)new Exception("XML Element invalid,  the paramter type is empty, the element is:" + paramEl));
                        valid = false;
                        break;
                    }
                    ServiceParam param = new ServiceParam(pName, pcls);
                    param.setDescription(paramEl.getTextTrim());
                    params.add(param);
                }
            }
            if (!valid) continue;
            service.setParams(params);
            Element returnEl = serviceEl.getChild("return");
            if (returnEl != null) {
                String rName = returnEl.getAttributeValue("name");
                String rcls = returnEl.getAttributeValue("class");
                ServiceParam returnParam = new ServiceParam(rName, rcls);
                returnParam.setDescription(returnEl.getText().trim());
                service.setReturnParam(returnParam);
            }
            this.services.put(path + ":" + name, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() throws Exception {
        URL url = this.getClass().getClassLoader().getResource(store_file);
        if (url == null) {
            url = ClassLoader.getSystemResource(store_file);
        }
        File file = new File(url.getFile());
        Element root = new Element("services");
        Iterator i = this.services.keySet().iterator();
        while (i.hasNext()) {
            ServiceParam returnParam;
            JavaService service = (JavaService)this.services.get(i.next());
            Element serviceEl = new Element("service");
            serviceEl.setAttribute("name", service.getName());
            serviceEl.setAttribute("path", service.getPath());
            if (service.getDescription() != null) {
                Element descEl = new Element("description");
                CDATA data = new CDATA(service.getDescription());
                descEl.addContent((Content)data);
                serviceEl.addContent((Content)descEl);
            }
            Element proxyEl = new Element("proxy");
            proxyEl.setText(service.getProxycls().getName());
            serviceEl.addContent((Content)proxyEl);
            List params = service.getParams();
            if (params != null && !params.isEmpty()) {
                Element paramsEl = new Element("params");
                for (int pi = 0; pi < params.size(); ++pi) {
                    ServiceParam param = (ServiceParam)params.get(pi);
                    Element paramEl = new Element("param");
                    paramEl.setAttribute("name", param.getName());
                    paramEl.setAttribute("class", param.getType());
                    if (param.getDescription() != null) {
                        CDATA data = new CDATA(param.getDescription());
                        paramEl.addContent((Content)data);
                    }
                    paramsEl.addContent((Content)paramEl);
                }
                serviceEl.addContent((Content)paramsEl);
            }
            if ((returnParam = service.getReturnParam()) != null) {
                Element returnEl = new Element("return");
                if (returnParam.getName() != null) {
                    returnEl.setAttribute("name", returnParam.getName());
                }
                returnEl.setAttribute("class", returnParam.getType());
                if (returnParam.getDescription() != null) {
                    CDATA data = new CDATA(returnParam.getDescription());
                    returnEl.addContent((Content)data);
                }
                serviceEl.addContent((Content)returnEl);
            }
            root.addContent((Content)serviceEl);
        }
        Document doc = new Document();
        doc.setRootElement(root);
        Format format = Format.getCompactFormat();
        format.setEncoding("UTF-8");
        format.setIndent("  ");
        XMLOutputter outputter = new XMLOutputter(format);
        FileOutputStream fout = null;
        OutputStreamWriter writer = null;
        try {
            fout = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)fout, "utf-8");
            outputter.output(doc, (Writer)writer);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close fout inputStream error!", (Throwable)e);
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close writer inputStream error!", (Throwable)e);
            }
        }
    }

    private boolean empty(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Override
    public List listRef() {
        ArrayList<ServiceRef> list = new ArrayList<ServiceRef>();
        Iterator i = this.services.keySet().iterator();
        while (i.hasNext()) {
            JavaService service = (JavaService)this.services.get(i.next());
            ServiceRef ref = this.getRef(service);
            list.add(ref);
        }
        return list;
    }

    private ServiceRef getRef(JavaService service) {
        ServiceRef ref = new ServiceRef();
        ref.setDescription(service.getDescription());
        ref.setName(service.getName());
        ref.setPath(service.getPath());
        List params = service.getParams();
        if (params != null) {
            ArrayList<Object> aParams = new ArrayList<Object>();
            for (int j = 0; j < params.size(); ++j) {
                ServiceParam param = (ServiceParam)params.get(j);
                aParams.add(param.clone());
            }
            ref.setParams(aParams);
        }
        if (service.getReturnParam() != null) {
            ref.setReturnParam((ServiceParam)service.getReturnParam().clone());
        }
        return ref;
    }

    @Override
    public ServiceRef getServiceRef(String path, String name) {
        JavaService service = (JavaService)this.services.get(path + ":" + name);
        if (service == null) {
            return null;
        }
        return this.getRef(service);
    }
}

