/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.manager;

import com.kingdee.bos.service.ICommonServiceManager;
import com.kingdee.bos.service.ServiceParam;
import com.kingdee.bos.service.ServiceRef;
import com.kingdee.bos.service.manager.ArrayParamWrapper;
import com.kingdee.bos.service.manager.IParamWrapper;
import com.kingdee.bos.service.manager.ParamWrapper;
import com.kingdee.bos.service.manager.QNameInfo;
import com.kingdee.bos.service.manager.WebService;
import com.kingdee.util.Configuration;
import com.kingdee.util.ObjectUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class WebServiceManager
implements ICommonServiceManager {
    private static final Logger logger = Logger.getLogger(WebServiceManager.class);
    private Map services = new HashMap();
    private Service axisService = null;
    private long openTime;
    private File storeFile;
    private static final String STORE_FILE_NAME = "WebServiceStore.xml";
    List refList = null;

    @Override
    public void destory() {
        try {
            this.store();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    public Object execute(String path, String name, Object[] values) throws Exception {
        String[] props;
        this.refreshList();
        WebService service = (WebService)this.services.get(path + ":" + name);
        if (service == null) {
            throw new NullPointerException("can't find service, path:" + path + ", name:" + name);
        }
        Call call = (Call)this.axisService.createCall();
        call.setTargetEndpointAddress(new URL(service.getEndPoint()));
        call.setOperationName(service.getOperationName());
        Set qnameInfos = service.getQnameInfos();
        if (qnameInfos != null) {
            for (QNameInfo qnameInfo : qnameInfos) {
                QName qname = new QName(qnameInfo.getNamespaceURI(), qnameInfo.getLocalPart());
                Class pcls = ObjectUtils.getArgumentTypeClass((String)qnameInfo.getClassName());
                call.registerTypeMapping(pcls, qname, (SerializerFactory)new BeanSerializerFactory(pcls, qname), (DeserializerFactory)new BeanDeserializerFactory(pcls, qname));
            }
        }
        Object[] nValues = null;
        if (values != null) {
            nValues = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value instanceof IParamWrapper) {
                    value = ((IParamWrapper)value).getObj();
                }
                nValues[i] = value;
            }
        }
        Object result = call.invoke(nValues);
        if (service.getReturnParam() != null && (props = service.getReturnParam().getWrapperProperties()) != null && props.length > 0) {
            if (result.getClass().isArray()) {
                return new ArrayParamWrapper((Object[])result, props);
            }
            return new ParamWrapper(result, props);
        }
        return result;
    }

    @Override
    public boolean exists(String path, String name) {
        return this.services.get(path + ":" + name) != null;
    }

    @Override
    public void init() throws Exception {
        this.load();
        this.axisService = new Service();
    }

    @Override
    public ServiceRef regiser(String content) throws Exception {
        return null;
    }

    @Override
    public boolean unregister(String path, String name) throws Exception {
        return false;
    }

    @Override
    public boolean valid(String path, String name) {
        return this.exists(path, name);
    }

    public void load() throws Exception {
        File file = Configuration.getServerRoot();
        if (file.exists()) {
            file = new File(file.getParentFile().getAbsoluteFile() + File.separator + "config" + File.separator + STORE_FILE_NAME);
        }
        if (!file.exists()) {
            URL url = this.getClass().getClassLoader().getResource(STORE_FILE_NAME);
            if (url == null) {
                url = WebServiceManager.class.getResource(STORE_FILE_NAME);
            }
            if (url == null) {
                url = ClassLoader.getSystemResource(STORE_FILE_NAME);
            }
            if (url == null) {
                logger.warn((Object)"can't load registered service manager. can't find file:WebServiceStore.xml");
                return;
            }
            file = new File(url.getFile());
        }
        this.storeFile = file;
        this.openTime = file.lastModified();
        SAXBuilder builder = new SAXBuilder();
        Element root = builder.build(file).getRootElement();
        List managerEls = root.getChildren("service");
        for (Element serviceEl : managerEls) {
            Element mappingsEl;
            Element operationEl;
            String name = serviceEl.getAttributeValue("name");
            String path = serviceEl.getAttributeValue("path");
            if (this.empty(name)) {
                logger.error((Object)("XML Elemenet invalid, service name is emtpy, the element is:" + serviceEl));
                continue;
            }
            Element endPointEl = serviceEl.getChild("endpoint");
            if (endPointEl == null || this.empty(endPointEl.getText())) {
                logger.error((Object)("XML Element invalid, serive's endpoint is emtpy, the element is:" + serviceEl));
                continue;
            }
            WebService service = new WebService();
            service.setEndPoint(endPointEl.getTextTrim());
            service.setName(name);
            service.setPath(path);
            Element descEl = serviceEl.getChild("description");
            if (descEl != null) {
                service.setDescription(descEl.getTextTrim());
            }
            if ((operationEl = serviceEl.getChild("operation")) == null || operationEl.getAttributeValue("name") == null) {
                logger.error((Object)("XML Elemenet invalid, serivce's method is empty, the element is:" + serviceEl));
                continue;
            }
            service.setOperationName(operationEl.getAttributeValue("name"));
            boolean valid = true;
            ArrayList<ServiceParam> params = null;
            List paramEls = operationEl.getChildren("param");
            if (paramEls != null) {
                params = new ArrayList<ServiceParam>();
                for (int pi = 0; pi < paramEls.size(); ++pi) {
                    Element paramEl = (Element)paramEls.get(pi);
                    String pName = paramEl.getAttributeValue("name");
                    String pcls = paramEl.getAttributeValue("class");
                    if (this.empty(pcls)) {
                        logger.error((Object)new Exception("XML Element invalid,  the paramter type is empty, the element is:" + paramEl));
                        valid = false;
                        break;
                    }
                    ServiceParam param = new ServiceParam(pName, pcls);
                    param.setDescription(paramEl.getTextTrim());
                    params.add(param);
                }
            }
            if (!valid) continue;
            service.setParams(params);
            Element returnEl = operationEl.getChild("return");
            if (returnEl != null) {
                String rName = returnEl.getAttributeValue("name");
                String rcls = returnEl.getAttributeValue("class");
                ServiceParam returnParam = new ServiceParam(rName, rcls);
                returnParam.setDescription(returnEl.getText().trim());
                returnParam.setWrapperProperties(returnEl.getAttributeValue("wrapper"));
                service.setReturnParam(returnParam);
            }
            if ((mappingsEl = serviceEl.getChild("type-mappings")) != null) {
                List mappings = mappingsEl.getChildren("mapping");
                HashSet<QNameInfo> qnameInfos = new HashSet<QNameInfo>();
                for (Element mappingEl : mappings) {
                    QNameInfo qnameInfo = new QNameInfo();
                    qnameInfo.setNamespaceURI(mappingEl.getAttributeValue("nsuri"));
                    qnameInfo.setLocalPart(mappingEl.getAttributeValue("lp"));
                    qnameInfo.setClassName(mappingEl.getTextTrim());
                    qnameInfos.add(qnameInfo);
                }
                service.setQnameInfos(qnameInfos);
            }
            this.services.put(path + ":" + name, service);
        }
    }

    @Override
    public void store() throws Exception {
    }

    private boolean empty(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Override
    public List listRef() {
        this.refreshList();
        return this.refList;
    }

    protected synchronized void refreshList() {
        boolean reloaded = false;
        if (this.refList == null) {
            this.refList = new ArrayList();
            reloaded = true;
        } else if (this.openTime != this.storeFile.lastModified()) {
            this.services.clear();
            try {
                this.load();
                this.refList.clear();
                reloaded = true;
            }
            catch (Exception ex) {
                logger.error((Object)"reload service error", (Throwable)ex);
            }
        }
        if (reloaded) {
            Iterator i = this.services.keySet().iterator();
            while (i.hasNext()) {
                WebService service = (WebService)this.services.get(i.next());
                ServiceRef ref = this.getRef(service);
                this.refList.add(ref);
            }
        }
    }

    private ServiceRef getRef(WebService service) {
        ServiceRef ref = new ServiceRef();
        ref.setDescription(service.getDescription());
        ref.setName(service.getName());
        ref.setPath(service.getPath());
        List params = service.getParams();
        if (params != null) {
            ArrayList<Object> aParams = new ArrayList<Object>();
            for (int j = 0; j < params.size(); ++j) {
                ServiceParam param = (ServiceParam)params.get(j);
                aParams.add(param.clone());
            }
            ref.setParams(aParams);
        }
        if (service.getReturnParam() != null) {
            ref.setReturnParam((ServiceParam)service.getReturnParam().clone());
        }
        return ref;
    }

    @Override
    public ServiceRef getServiceRef(String path, String name) {
        WebService service = (WebService)this.services.get(path + ":" + name);
        if (service == null) {
            return null;
        }
        return this.getRef(service);
    }
}

