/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.spi;

import com.kingdee.bos.spi.SPConfig;
import com.kingdee.bos.spi.SPInfo;
import com.kingdee.util.ConfigurationException;
import com.kingdee.util.ConfigurationItem;
import java.util.Map;
import org.apache.log4j.Logger;

public class SPManager {
    private static final Logger logger = Logger.getLogger(SPManager.class);
    static SPManager instance = new SPManager();
    private SPConfig config = null;

    SPManager() {
    }

    private synchronized void lazyInit() {
        if (this.config != null) {
            return;
        }
        this.config = new SPConfig();
        boolean loadSuccess = false;
        try {
            loadSuccess = this.config.loadConfig();
        }
        catch (ConfigurationException e) {
            logger.error((Object)"cannot load ServiceProviderImpl.xml", (Throwable)e);
        }
        if (!loadSuccess) {
            SPManager sPManager = this;
            logger.error((Object)("ServiceProviderConfig init error, " + sPManager.config.getConfigFilePath() + " cannot found"));
            this.config.configError = true;
        }
    }

    void reload() {
        this.config = null;
        this.lazyInit();
    }

    private SPInfo loadSPinfo(ConfigurationItem item) {
        String serviceName = item.getName();
        Map attributes = item.getProperties();
        SPInfo spinfo = new SPInfo(serviceName, attributes);
        this.LoadProviderClass(spinfo);
        return spinfo;
    }

    private void LoadProviderClass(SPInfo spinfo) {
        String className = spinfo.getProviderClassName();
        Class<?> clazz = null;
        if (className != null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("cannot load serviceProvider Class " + className), (Throwable)e);
            }
        }
        if (clazz != null) {
            spinfo.setProviderClass(clazz);
        } else {
            logger.error((Object)("cannot load serviceProvider Class for service " + spinfo.getServiceName()));
        }
    }

    public SPInfo getSeviceProvider(String serviceName) {
        this.lazyInit();
        ConfigurationItem item = this.config.getServiceProvicerInfo(serviceName);
        if (item == null) {
            return null;
        }
        return this.loadSPinfo(item);
    }

    public Object getSeviceProviderInstance(String serviceName) {
        SPInfo spinfo = SPManager.getInstance().getSeviceProvider(serviceName);
        if (spinfo != null && spinfo.getProviderClass() != null) {
            Class clazz = spinfo.getProviderClass();
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)"cannot create instance via access Constructor", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isSPInstalled(String serviceName) {
        SPInfo spinfo = SPManager.getInstance().getSeviceProvider(serviceName);
        return spinfo != null && spinfo.getProviderClass() != null;
    }

    public static boolean isEASInstalled() {
        return SPManager.isSPInstalled("SwitchBookImpl");
    }

    public static SPManager getInstance() {
        return instance;
    }
}

