/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.calculator;

import com.kingdee.bos.streamwork.calculator.ExecuteContext;
import com.kingdee.bos.streamwork.calculator.ExprBase;
import com.kingdee.bos.streamwork.calculator.Visitor;
import java.util.ArrayList;

public class CompoundId
extends ExprBase {
    private ArrayList names = new ArrayList();

    public CompoundId(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public CompoundId(String name) {
        this(name, false);
    }

    public void append(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public void append(String name) {
        this.names.add(new NamePart(name, false));
    }

    public String[] toStringArray() {
        String[] ret = new String[this.names.size()];
        int i = 0;
        for (NamePart np : this.names) {
            ret[i++] = np.name;
        }
        return ret;
    }

    private CompoundId() {
    }

    public Object clone() {
        CompoundId cloned = new CompoundId();
        for (NamePart np : this.names) {
            cloned.append(np.name, np.isKey);
        }
        return cloned;
    }

    public String toString() {
        String str = "";
        boolean isFollow = false;
        for (NamePart np : this.names) {
            if (isFollow) {
                str = str + ".";
            }
            isFollow = true;
            str = str + "[" + np.name + "]";
        }
        return str;
    }

    @Override
    public Object execute(ExecuteContext context) {
        if (this.names.size() == 1) {
            String name = ((NamePart)this.names.get(0)).name;
            return context.getValue(name);
        }
        return null;
    }

    @Override
    public void accept(Visitor vistor) {
        vistor.visit(this);
    }

    private class NamePart {
        private String name;
        private boolean isKey;

        protected NamePart(String name, boolean isKey) {
            this.name = name.startsWith("[") ? name.substring(1, name.length() - 1) : name;
            this.isKey = isKey;
        }
    }
}

