/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.calculator;

import com.kingdee.bos.streamwork.calculator.ExecuteContext;
import com.kingdee.bos.streamwork.calculator.Expr;
import com.kingdee.bos.streamwork.calculator.ExprBase;
import com.kingdee.bos.streamwork.calculator.ExpressionException;
import com.kingdee.bos.streamwork.calculator.FunDef;
import com.kingdee.bos.streamwork.calculator.Visitor;

public class FunCall
extends ExprBase {
    public static final int FUNCTION = 0;
    public static final int METHOD = 1;
    public static final int PROPERTY = 2;
    private String name;
    private Expr[] params;
    private int type;

    FunCall(String name, Expr[] params) {
        this.name = name;
        this.params = params;
        this.type = 0;
    }

    FunCall(String name, Expr[] params, int type) {
        this.name = name;
        this.params = params;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Expr[] getParams() {
        return this.params;
    }

    public static boolean isFunCall(String name) {
        return FunDef.contains(name.toUpperCase());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 0: {
                sb.append(this.name).append("(");
                for (int i = 0; i < this.params.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.params[i].toString());
                }
                sb.append(")");
                break;
            }
            case 1: {
                sb.append(this.params[0].toString()).append(".").append(this.name).append("(");
                for (int i = 1; i < this.params.length; ++i) {
                    if (i > 1) {
                        sb.append(",");
                    }
                    sb.append(this.params[i].toString());
                }
                sb.append(")");
                break;
            }
            case 2: {
                sb.append(this.params[0].toString()).append(".").append(this.name);
            }
        }
        return sb.toString();
    }

    @Override
    public Object execute(ExecuteContext context) {
        FunDef funDef = FunDef.getFunDef(this.name);
        if (funDef == null) {
            throw new ExpressionException("\u51fd\u6570" + this.name + "\u4e0d\u5b58\u5728.");
        }
        return FunDef.getFunDef(this.name).execute(this, context);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].accept(visitor);
        }
    }
}

