/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.calculator;

import com.kingdee.bos.streamwork.calculator.ExecuteContext;
import com.kingdee.bos.streamwork.calculator.Expr;
import com.kingdee.bos.streamwork.calculator.ExpressionException;
import com.kingdee.bos.streamwork.calculator.FunCall;
import com.kingdee.bos.streamwork.calculator.FunCallExecutable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public abstract class FunDef
implements FunCallExecutable {
    private String name;
    private static HashMap<String, FunDef> defs = new HashMap();
    private static SimpleDateFormat dateFormat;
    private static SimpleDateFormat[] dateFormats;

    FunDef(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static void register(FunDef def) {
        FunDef.register(def.getName().toUpperCase(), def);
    }

    public static void register(String name, FunDef def) {
        defs.put(name.toUpperCase(), def);
    }

    public static void register(String name, final FunCallExecutable e) {
        if (e instanceof FunDef) {
            FunDef.register(name, (FunDef)e);
        } else {
            FunDef.register(new FunDef(name){

                @Override
                public Object execute(FunCall call, ExecuteContext context) {
                    return e.execute(call, context);
                }
            });
        }
    }

    public static void register(String[] names, FunCallExecutable e) {
        for (String name : names) {
            FunDef.register(name, e);
        }
    }

    public static boolean contains(String name) {
        return defs.containsKey(name.toUpperCase());
    }

    public static String[] getAllFuncNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(defs.keySet());
        Collections.sort(list);
        return list.toArray(new String[0]);
    }

    private static String myToString(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return dateFormat.format((Date)v);
        }
        return v.toString();
    }

    private static Date myToDate(String v) {
        if (v == null) {
            return null;
        }
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                dateFormats[i].setLenient(false);
                return dateFormats[i].parse(v);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    public static String replace(String str, String r, String replacement, int n) {
        if (replacement == null) {
            replacement = "";
        }
        if (r == null || r.equals("")) {
            return str;
        }
        int len = r.length();
        int rlen = replacement.length();
        int from = 0;
        for (int num = 0; num < n; ++num) {
            int pos = str.indexOf(r, from);
            if (pos < 0) {
                return str;
            }
            str = str.substring(0, pos) + replacement + str.substring(pos + len);
            from = pos + rlen;
        }
        return str;
    }

    public static String substitute(String text, String old_text, String new_text, int number) {
        if (new_text == null) {
            new_text = "";
        }
        if (old_text == null || old_text.equals("")) {
            return text;
        }
        int len = old_text.length();
        int rlen = new_text.length();
        int pos = 0;
        int from = 0;
        for (int num = 0; num < number; ++num) {
            pos = text.indexOf(old_text, from);
            if (pos < 0) {
                return text;
            }
            from = pos + len;
        }
        text = text.substring(0, pos) + new_text + text.substring(pos + len);
        return text;
    }

    private static Object round_(FunCall call, ExecuteContext context, int roundMode) {
        String name = call.getName();
        Expr[] exprs = call.getParams();
        if (exprs.length != 2) {
            throw new ExpressionException(name + "\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1a" + name + "(<\u6570\u5b57>,<\u7cbe\u5ea6>)");
        }
        Object v = exprs[0].execute(context);
        if (v == null) {
            return 0;
        }
        if (!(v instanceof Number)) {
            throw new ExpressionException(name + "\u51fd\u6570\u53c2\u6570\u5fc5\u987b\u4e3a\u6570\u5b57");
        }
        BigDecimal bd = new BigDecimal(v.toString());
        Object v2 = exprs[1].execute(context);
        if (!(v2 instanceof Number)) {
            throw new ExpressionException(name + "\u51fd\u6570\u53c2\u6570\u5fc5\u987b\u4e3a\u6570\u5b57");
        }
        int scale = ((Number)v2).intValue();
        BigDecimal r = bd.setScale(scale, roundMode);
        if (scale > 0) {
            return r.doubleValue();
        }
        return r.intValue();
    }

    private static void initFunctions() {
        FunDef.register(new FunDef("YEAR"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("YEAR\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aYEAR([\u65e5\u671f\u5b57\u6bb5])");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                if (v != null && v instanceof String) {
                    v = FunDef.myToDate((String)v);
                }
                if (v == null || !(v instanceof Date)) {
                    throw new ExpressionException("YEAR\u51fd\u6570\u6761\u4ef6\u53ea\u63a5\u53d7\u65e5\u671f\u5b57\u6bb5");
                }
                Date date = (Date)v;
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return cal.get(1);
            }
        });
        FunDef.register(new FunDef("MONTH"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("MONTH\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aMONTH([\u65e5\u671f\u5b57\u6bb5])");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                if (v != null && v instanceof String) {
                    v = FunDef.myToDate((String)v);
                }
                if (v == null || !(v instanceof Date)) {
                    throw new ExpressionException("MONTH\u51fd\u6570\u6761\u4ef6\u53ea\u63a5\u53d7\u65e5\u671f\u5b57\u6bb5");
                }
                Date date = (Date)v;
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return cal.get(2) + 1;
            }
        });
        FunDef.register(new FunDef("DAY"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("DAY\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aDAY([\u65e5\u671f\u5b57\u6bb5])");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                if (v != null && v instanceof String) {
                    v = FunDef.myToDate((String)v);
                }
                if (v == null || !(v instanceof Date)) {
                    throw new ExpressionException("DAY\u51fd\u6570\u6761\u4ef6\u53ea\u63a5\u53d7\u65e5\u671f\u5b57\u6bb5");
                }
                Date date = (Date)v;
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return cal.get(5);
            }
        });
        FunDef.register(new FunDef("QUARTER"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("QUARTER\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aQUARTER([\u65e5\u671f])");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                if (v != null && v instanceof String) {
                    v = FunDef.myToDate((String)v);
                }
                if (!(v instanceof Date)) {
                    throw new ExpressionException("QUARTER\u51fd\u6570\u6761\u4ef6\u53ea\u63a5\u53d7\u65e5\u671f");
                }
                Date date = (Date)v;
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                int month = cal.get(2);
                return month / 3 + 1;
            }
        });
        FunDef.register(new FunDef("ROUND"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                return FunDef.round_(call, context, 4);
            }
        });
        FunDef.register(new FunDef("ROUNDUP"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                return FunDef.round_(call, context, 0);
            }
        });
        FunDef.register(new FunDef("ROUNDDOWN"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                return FunDef.round_(call, context, 1);
            }
        });
        FunDef.register(new FunDef("IF"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 3) {
                    throw new ExpressionException("IF\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aIF(\u6761\u4ef6,\u771f\u503c,\u5047\u503c)");
                }
                Object v = exprs[0].execute(context);
                Boolean b = null;
                if (v == null) {
                    b = Boolean.FALSE;
                } else if (v instanceof Boolean) {
                    b = (Boolean)v;
                } else {
                    throw new ExpressionException("IF\u51fd\u6570\u6761\u4ef6\u5fc5\u987b\u4e3a\u5e03\u5c14\u503c");
                }
                if (b.booleanValue()) {
                    return exprs[1].execute(context);
                }
                return exprs[2].execute(context);
            }
        });
        FunDef.register(new String[]{"TEXT", "T"}, new FunCallExecutable(){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                String name = call.getName();
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException(name + "\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1a" + name + "(<\u503c>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                return FunDef.myToString(v);
            }
        });
        FunDef.register(new FunDef("LEFT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new ExpressionException("LEFT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aLEFT(<\u5b57\u7b26\u4e32>,<\u957f\u5ea6>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                String str = FunDef.myToString(v);
                v = exprs[1].execute(context);
                if (!(v instanceof Number)) {
                    throw new ExpressionException("LEFT\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u6574\u6570");
                }
                int len = ((Number)v).intValue();
                if (len <= 0) {
                    throw new ExpressionException("LEFT\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
                }
                if (len > str.length()) {
                    len = str.length();
                }
                return str.substring(0, len);
            }
        });
        FunDef.register(new FunDef("RIGHT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new ExpressionException("RIGHT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aRIGHT(<\u5b57\u7b26\u4e32>,<\u957f\u5ea6>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                String str = FunDef.myToString(v);
                v = exprs[1].execute(context);
                if (!(v instanceof Number)) {
                    throw new ExpressionException("RIGHT\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u6574\u6570");
                }
                int len = ((Number)v).intValue();
                if (len <= 0) {
                    throw new ExpressionException("RIGHT\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
                }
                int len2 = str.length();
                int start = len2 - len;
                if (start <= 0) {
                    return str;
                }
                if (len + start > str.length()) {
                    len = str.length() - start;
                }
                return str.substring(start, start + len);
            }
        });
        FunDef.register(new FunDef("MID"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 3) {
                    throw new ExpressionException("MID\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aMID(text, start_num, num_chars)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                String str = v.toString();
                v = exprs[1].execute(context);
                int from = -1;
                if (!(v instanceof Integer)) {
                    try {
                        from = Integer.parseInt(v.toString());
                    }
                    catch (Exception exception) {}
                } else {
                    from = (Integer)v;
                }
                if (from < 0) {
                    throw new ExpressionException("start_num\u5fc5\u987b\u4e3a>=0\u7684\u6574\u6570.");
                }
                v = exprs[2].execute(context);
                int len = -1;
                if (!(v instanceof Integer)) {
                    try {
                        len = Integer.parseInt(v.toString());
                    }
                    catch (Exception exception) {}
                } else {
                    len = (Integer)v;
                }
                if (len <= 0) {
                    throw new ExpressionException("num_chars\u5fc5\u987b\u4e3a>0\u7684\u6574\u6570.");
                }
                if (len + from > str.length()) {
                    len = str.length() - from;
                }
                return str.substring(from, from + len);
            }
        });
        FunDef.register(new FunDef("ABS"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("ABS\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aABS(<\u6570\u5b57>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                if (!(v instanceof Number)) {
                    throw new ExpressionException("ABS\u51fd\u6570\u53c2\u6570\u5fc5\u987b\u4e3a\u6570\u5b57");
                }
                if (((Number)v).doubleValue() > 0.0) {
                    return v;
                }
                if (v instanceof Integer) {
                    return -1 * (Integer)v;
                }
                if (v instanceof Number) {
                    return ((Number)v).doubleValue() * -1.0;
                }
                return null;
            }
        });
        FunDef.register(new FunDef("REPT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new ExpressionException("REPT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aREPT(<\u5b57\u7b26\u4e32>,NUM)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                String str = FunDef.myToString(v);
                v = exprs[1].execute(context);
                if (!(v instanceof Number)) {
                    throw new ExpressionException("REPT\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u6574\u6570");
                }
                int len = ((Number)v).intValue();
                if (len <= 0) {
                    throw new ExpressionException("REPT\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < len; ++i) {
                    sb.append(str);
                }
                return sb.toString();
            }
        });
        FunDef.register(new FunDef("TRIM"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("TRIM\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aTRIM(<\u5b57\u7b26\u4e32>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                String str = FunDef.myToString(v);
                String trim = str.trim();
                while (trim.length() != str.length()) {
                    str = trim;
                    trim = 16.replace(str, "  ", " ", 100);
                }
                return trim;
            }
        });
        FunDef.register(new FunDef("LOWER"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("LOWER\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aLOWER(<\u5b57\u7b26\u4e32>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                String str = FunDef.myToString(v);
                return str.toLowerCase();
            }
        });
        FunDef.register(new FunDef("UPPER"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("UPPER\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aUPPER(<\u5b57\u7b26\u4e32>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                String str = FunDef.myToString(v);
                return str.toUpperCase();
            }
        });
        FunDef.register(new FunDef("FIND"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                int find;
                Expr[] exprs = call.getParams();
                if (exprs.length != 2 && exprs.length != 3) {
                    throw new ExpressionException("FIND\u51fd\u6570\u9700\u89812-3\u4e2a\u53c2\u6570,\u683c\u5f0f(\u53c2\u8003Excel)\uff1aFIND(find_text, within_text, [start_num])");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return 0;
                }
                String find_text = FunDef.myToString(v);
                v = exprs[1].execute(context);
                if (v == null) {
                    return -1;
                }
                String within_text = FunDef.myToString(v);
                int start_num = 0;
                if (exprs.length > 2) {
                    v = exprs[2].execute(context);
                    if (v instanceof Number) {
                        start_num = ((Number)v).intValue();
                    }
                    if (start_num <= 0) {
                        start_num = 0;
                    }
                }
                if (start_num > within_text.length()) {
                    return -1;
                }
                if (start_num > 0) {
                    within_text = within_text.substring(start_num);
                }
                if ((find = within_text.indexOf(find_text)) < 0) {
                    return -1;
                }
                return start_num + find;
            }
        });
        FunDef.register(new String[]{"CONCAT", "CONCATENATE"}, new FunCallExecutable(){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                String result = "";
                for (Expr expr : exprs) {
                    Object v = expr.execute(context);
                    if (v == null) continue;
                    result = result + FunDef.myToString(v);
                }
                return result;
            }
        });
        FunDef.register(new FunDef("SUBSTITUTE"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 3 && exprs.length != 4) {
                    throw new ExpressionException("SUBSTITUTE\u51fd\u6570\u9700\u89813-4\u4e2a\u53c2\u6570,\u683c\u5f0f(\u53c2\u8003Excel)\uff1aSUBSTITUTE(text,old_text,new_text,instance_num)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                String str = FunDef.myToString(v);
                v = exprs[1].execute(context);
                if (v == null) {
                    return str;
                }
                String old_text = FunDef.myToString(v);
                v = exprs[2].execute(context);
                if (v == null) {
                    return "";
                }
                String new_text = FunDef.myToString(v);
                if (exprs.length > 3) {
                    v = exprs[3].execute(context);
                    if (!(v instanceof Number)) {
                        throw new ExpressionException("SUBSTITUTE\u51fd\u6570\u7b2c4\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
                    }
                    int num = ((Number)v).intValue();
                    if (num <= 0) {
                        throw new ExpressionException("SUBSTITUTE\u51fd\u6570\u7b2c4\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
                    }
                    return 21.substitute(str, old_text, new_text, num);
                }
                return 21.replace(str, old_text, new_text, Integer.MAX_VALUE);
            }
        });
        FunDef.register(new FunDef("DATEDIF"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 3) {
                    throw new ExpressionException("DATEDIF\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570,\u683c\u5f0f(\u53c2\u8003Excel)\uff1aDATEDIF(start_date,end_date,unit),unit\u53ef\u4ee5\u4e3aY,M,D");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return -1;
                }
                if (v != null && v instanceof String) {
                    v = FunDef.myToDate((String)v);
                }
                if (v == null || !(v instanceof Date)) {
                    throw new ExpressionException("\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b \u4e3a\u975e\u7a7a\u65e5\u671f");
                }
                Date date1 = (Date)v;
                v = exprs[1].execute(context);
                if (v == null) {
                    return -1;
                }
                if (v != null && v instanceof String) {
                    v = FunDef.myToDate((String)v);
                }
                if (v == null || !(v instanceof Date)) {
                    throw new ExpressionException("\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b \u4e3a\u975e\u7a7a\u65e5\u671f");
                }
                Date date2 = (Date)v;
                v = exprs[2].execute(context);
                if (v == null) {
                    throw new ExpressionException("\u7b2c\u4e09\u4e2a\u53c2\u6570\u5fc5\u987b \u4e3a\u975e\u7a7a\u5b57\u7b26\u4e32");
                }
                if (date2.compareTo(date1) <= 0) {
                    return null;
                }
                String unit = v.toString();
                if ("Y".equalsIgnoreCase(unit)) {
                    int monthdif = date2.getYear() * 12 + date2.getMonth() - (date1.getYear() * 12 + date1.getMonth());
                    if (date2.getDate() < date1.getDate()) {
                        --monthdif;
                    }
                    if (monthdif < 0) {
                        return 0;
                    }
                    return monthdif / 12;
                }
                if ("M".equalsIgnoreCase(unit)) {
                    int monthdif = date2.getYear() * 12 + date2.getMonth() - (date1.getYear() * 12 + date1.getMonth());
                    if (date2.getDate() < date1.getDate()) {
                        --monthdif;
                    }
                    return monthdif;
                }
                if ("D".equalsIgnoreCase(unit)) {
                    return (date2.getTime() - date1.getTime()) / 86400000L;
                }
                throw new ExpressionException("unit\u4e0d\u5408\u6cd5:" + unit);
            }
        });
        FunDef.register(new FunDef("NOW"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                return cal.getTime();
            }
        });
        FunDef.register(new FunDef("TODAY"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                int year = cal.get(1);
                int month = cal.get(2);
                int date = cal.get(5);
                return new Date(year - 1900, month, date);
            }
        });
        FunDef.register(new FunDef("LEN"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("LEN\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aLEN(<\u5b57\u7b26\u4e32>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return 0;
                }
                return v.toString().length();
            }
        });
        FunDef.register(new FunDef("INT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException("INT\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aINT(<\u503c>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                if (v instanceof Number) {
                    return ((Number)v).intValue();
                }
                int i = 0;
                try {
                    i = (int)Double.parseDouble(v.toString());
                }
                catch (Exception e) {
                    i = 0;
                }
                return i;
            }
        });
        FunDef.register(new FunDef("DATE"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length == 0) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(System.currentTimeMillis());
                    return cal.getTime();
                }
                if (exprs.length == 1) {
                    Object v = exprs[0].execute(context);
                    if (v == null) {
                        return null;
                    }
                    if (v instanceof Date) {
                        return (Date)v;
                    }
                    String s = v.toString();
                    return FunDef.myToDate(s);
                }
                if (exprs.length != 3) {
                    throw new ExpressionException("Date\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aDate(year, month, day)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    throw new ExpressionException("year\u4e0d\u80fd\u4e3a\u7a7a");
                }
                int year = -1;
                try {
                    year = Integer.parseInt(v.toString());
                }
                catch (Throwable t) {
                    throw new ExpressionException("year\u5fc5\u987b\u4e3a\u6574\u6570");
                }
                v = exprs[1].execute(context);
                if (v == null) {
                    throw new ExpressionException("month\u4e0d\u80fd\u4e3a\u7a7a");
                }
                int month = -1;
                try {
                    month = Integer.parseInt(v.toString());
                }
                catch (Throwable t) {
                    throw new ExpressionException("month\u5fc5\u987b\u4e3a\u6574\u6570");
                }
                v = exprs[2].execute(context);
                if (v == null) {
                    throw new ExpressionException("day\u4e0d\u80fd\u4e3a\u7a7a");
                }
                int day = -1;
                try {
                    day = Integer.parseInt(v.toString());
                }
                catch (Throwable t) {
                    throw new ExpressionException("day\u5fc5\u987b\u4e3a\u6574\u6570");
                }
                return new Date(year - 1900, month, day);
            }
        });
        FunDef.register(new String[]{"NUMBER", "VALUE"}, new FunCallExecutable(){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                String name = call.getName();
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new ExpressionException(name + "\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1a" + name + "(<\u5b57\u7b26\u4e32>)");
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                if (v instanceof Number) {
                    if ((double)((Number)v).intValue() == ((Number)v).doubleValue()) {
                        return ((Number)v).intValue();
                    }
                    return ((Number)v).doubleValue();
                }
                double i = 0.0;
                try {
                    i = Double.parseDouble(v.toString());
                    if (i == (double)((int)i)) {
                        return (int)i;
                    }
                    return i;
                }
                catch (Exception e) {
                    return 0;
                }
            }
        });
        FunDef.register(new FunDef("EMPTY_TO_INT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new ExpressionException("EMPTY_TO_INT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aEMPTY_TO_INT(<\u7a7a\u503c\u5b57\u6bb5>,<\u6574\u6570>)");
                }
                Object v = exprs[0].execute(context);
                if (v != null) {
                    return v;
                }
                v = exprs[1].execute(context);
                if (v instanceof Number) {
                    return ((Number)v).intValue();
                }
                int i = 0;
                try {
                    i = (int)Double.parseDouble(v.toString());
                }
                catch (Exception e) {
                    i = 0;
                }
                return i;
            }
        });
        FunDef.register(new FunDef("EMPTY_TO_NUMBER"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new ExpressionException("EMPTY_TO_NUMBER\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aEMPTY_TO_NUMBER(<\u7a7a\u503c\u5b57\u6bb5>,<\u6570\u503c>)");
                }
                Object v = exprs[0].execute(context);
                if (v != null) {
                    return v;
                }
                v = exprs[1].execute(context);
                if (v instanceof Number) {
                    return ((Number)v).doubleValue();
                }
                double i = 0.0;
                try {
                    i = Double.parseDouble(v.toString());
                }
                catch (Exception e) {
                    i = 0.0;
                }
                return i;
            }
        });
        FunDef.register(new FunDef("EMPTY_TO_TEXT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new ExpressionException("EMPTY_TO_TEXT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1aEMPTY_TO_TEXT(<\u7a7a\u5b57\u7b26\u4e32>,<\u5b57\u7b26\u4e32>)");
                }
                Object v = exprs[0].execute(context);
                if (v != null) {
                    return v;
                }
                v = exprs[1].execute(context);
                v = v == null ? "" : v.toString();
                return v;
            }
        });
    }

    public static FunDef getFunDef(String name) {
        return defs.get(name.toUpperCase());
    }

    static {
        FunDef.initFunctions();
        dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy/MM/dd")};
    }
}

