/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.calculator;

import com.kingdee.bos.streamwork.calculator.ExecuteContext;
import com.kingdee.bos.streamwork.calculator.Expr;
import com.kingdee.bos.streamwork.calculator.ExpressionException;

public abstract class Operator {
    public static final Operator AND = new Operator("and"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left instanceof Boolean && right instanceof Boolean) {
                return (Boolean)left != false && (Boolean)right != false;
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,and\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61");
        }
    };
    public static final Operator OR = new Operator("or"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left instanceof Boolean && right instanceof Boolean) {
                return (Boolean)left != false || (Boolean)right != false;
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,or\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61");
        }
    };
    public static final Operator XOR = new Operator("xor"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left instanceof Boolean && right instanceof Boolean) {
                return ((Boolean)left).booleanValue() != ((Boolean)right).booleanValue();
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,xor\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61");
        }
    };
    public static final Operator NOT = new Operator("not"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object o = params[0].execute(context);
            if (o instanceof Boolean) {
                return (Boolean)o == false;
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,not\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61");
        }
    };
    public static final Operator PLUS = new Operator("+"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            if (left instanceof String) {
                return (String)left + right.toString();
            }
            if (left instanceof Number && right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return new Double(((Number)left).doubleValue() + ((Number)right).doubleValue());
                }
                return new Integer(((Number)left).intValue() + ((Number)right).intValue());
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,+\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u6216\u5b57\u7b26\u4e32\u5bf9\u8c61");
        }
    };
    public static final Operator MINUS = new Operator("-"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                left = 0;
            }
            if (right == null) {
                return left;
            }
            if (left instanceof Number && right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return new Double(((Number)left).doubleValue() - ((Number)right).doubleValue());
                }
                return new Integer(((Number)left).intValue() - ((Number)right).intValue());
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,-\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator TIMES = new Operator("*"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null || right == null) {
                return null;
            }
            if (left instanceof Number && right instanceof Number) {
                if (left instanceof Double || right instanceof Double) {
                    return new Double(((Number)left).doubleValue() * ((Number)right).doubleValue());
                }
                return new Integer(((Number)left).intValue() * ((Number)right).intValue());
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,*\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator DIVIDE = new Operator("/"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null || right == null) {
                return null;
            }
            if (left instanceof Number && right instanceof Number) {
                if (((Number)right).doubleValue() == 0.0) {
                    return null;
                }
                return new Double(((Number)left).doubleValue() / ((Number)right).doubleValue());
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,/\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator UMINUS = new Operator("-"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object right = params[0].execute(context);
            if (right == null) {
                return null;
            }
            if (right instanceof Number) {
                if (right instanceof Double) {
                    return new Double(-((Number)right).doubleValue());
                }
                return new Integer(-((Number)right).intValue());
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,-\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator EQ = new Operator("="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.TRUE;
            }
            if (left == null || right == null) {
                return Boolean.FALSE;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() == ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                return ((String)left).equalsIgnoreCase((String)right);
            }
            if (left == right) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    };
    public static final Operator GT = new Operator(">"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.FALSE;
            }
            if (left == null) {
                return Boolean.FALSE;
            }
            if (right == null) {
                return Boolean.TRUE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() > ((Number)right).doubleValue());
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,>\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator GE = new Operator(">="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.TRUE;
            }
            if (left == null) {
                return Boolean.FALSE;
            }
            if (right == null) {
                return Boolean.TRUE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() >= ((Number)right).doubleValue());
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,>=\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator LT = new Operator("<"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.FALSE;
            }
            if (left == null) {
                return Boolean.TRUE;
            }
            if (right == null) {
                return Boolean.FALSE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() < ((Number)right).doubleValue());
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,<\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator LE = new Operator("<="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.TRUE;
            }
            if (left == null) {
                return Boolean.TRUE;
            }
            if (right == null) {
                return Boolean.FALSE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() <= ((Number)right).doubleValue());
            }
            throw new ExpressionException("\u6267\u884c\u51fa\u9519,<=\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61");
        }
    };
    public static final Operator NE = new Operator("<>"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.FALSE;
            }
            if (left == null) {
                return Boolean.TRUE;
            }
            if (right == null) {
                return Boolean.TRUE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new Boolean(((Number)left).doubleValue() != ((Number)right).doubleValue());
            }
            return !left.equals(right);
        }
    };
    public static final Operator CONCAT = new Operator("&"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            return 16.concat(context, params);
        }
    };
    private String name;

    protected static String concat(ExecuteContext context, Expr[] params) {
        Object left = params[0].execute(context);
        Object right = params[1].execute(context);
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right.toString();
        }
        if (right == null) {
            return left.toString();
        }
        return left.toString() + right.toString();
    }

    private Operator(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public abstract Object execute(ExecuteContext var1, Expr[] var2);
}

