/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.streamwork.client.UIDesc;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.service.IStreamWorkService;
import com.kingdee.bos.streamwork.service.StreamWorkServiceFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class QuerySchemaListUI
extends KDPanel {
    private UIDesc uiDesc;
    private IStreamWorkService service;
    private KDTable table;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    ArrayList<String> names = new ArrayList();
    SelectListener listener;

    public QuerySchemaListUI(UIDesc uiDesc) throws BOSException {
        this.uiDesc = uiDesc;
        this.service = StreamWorkServiceFactory.createRemoteObject();
        int pos = uiDesc.id.indexOf("$$EnhancerByCGLIB$$");
        if (pos > 0) {
            uiDesc.id = uiDesc.id.substring(0, pos);
        }
        this.initUI();
    }

    private void initUI() {
        this.table = new KDTable();
        this.table.getSelectManager().setSelectMode(2);
        this.table.setEditable(false);
        this.table.setAutoscrolls(true);
        this.table.setAutoResize(true);
        this.table.addColumns(3);
        this.table.getColumn(0).setWidth(300);
        this.table.getColumn(1).setWidth(200);
        this.table.getColumn(2).setWidth(100);
        IRow header = this.table.addHeadRow();
        header.getCell(0).setValue((Object)"\u65b9\u6848\u540d\u79f0");
        header.getCell(1).setValue((Object)"\u4fdd\u5b58\u65f6\u95f4");
        header.getCell(2).setValue((Object)"\u9ed8\u8ba4");
        this.table.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                QuerySchemaListUI.this.select(e.getSelectBlock().getTop(), false);
            }
        });
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    int rowIndex = e.getRowIndex();
                    QuerySchemaListUI.this.select(rowIndex, true);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.table, "Center");
        KDPanel topPanel = new KDPanel();
        topPanel.setLayout((LayoutManager)new BorderLayout());
        KDPanel topLeftPanel = new KDPanel();
        topLeftPanel.setLayout((LayoutManager)new FlowLayout(0));
        topLeftPanel.add((Component)new JLabel("\u65b9\u6848\u5217\u8868:"));
        topPanel.add((Component)topLeftPanel, (Object)"West");
        KDPanel topRightPanel = new KDPanel();
        topRightPanel.setLayout((LayoutManager)new FlowLayout(2));
        KDButton btnDelete = new KDButton("\u5220\u9664");
        topRightPanel.add((Component)btnDelete);
        KDButton btnSetDefault = new KDButton("\u8bbe\u4e3a\u9ed8\u8ba4");
        topRightPanel.add((Component)btnSetDefault);
        topPanel.add((Component)topRightPanel, (Object)"East");
        this.add((Component)topPanel, "North");
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuerySchemaListUI.this.onDelete();
            }
        });
        btnSetDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuerySchemaListUI.this.onSetDefault();
            }
        });
    }

    public void loadTable() throws BOSException {
        this.loadTable(null);
    }

    private void loadTable(String selectedName) throws BOSException {
        this.table.removeRows();
        this.names.clear();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("ui", this.uiDesc.id);
        Map[] data = this.service.listQuerySchema(params);
        Calendar cal = Calendar.getInstance();
        int selectedIndex = -1;
        for (int i = 0; i < data.length; ++i) {
            IRow row = this.table.addRow();
            String name = (String)data[i].get("name");
            if (name.equals(selectedName)) {
                selectedIndex = i;
            }
            row.getCell(0).setValue((Object)name);
            this.names.add(name);
            Timestamp ts = (Timestamp)data[i].get("updateTime");
            cal.setTimeInMillis(ts.getTime());
            String d = dateFormat.format(cal.getTime());
            row.getCell(1).setValue((Object)d);
            boolean isdefault = (Boolean)data[i].get("isdefault");
            row.getCell(2).setValue((Object)(isdefault ? "\u662f" : "\u5426"));
        }
        if (selectedIndex > -1) {
            this.table.getSelectManager().select(selectedIndex, 0);
        }
    }

    private void onDelete() {
        String name = this.getSelectName();
        if (name == null) {
            PivotUtils.alert("\u6ca1\u6709\u9009\u62e9\u884c", PivotUtils.getParentFrame((JComponent)((Object)this)));
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("ui", this.uiDesc.id);
        try {
            this.service.deleteQuerySchema(name, params);
            this.loadTable();
        }
        catch (BOSException e) {
            e.printStackTrace();
            PivotUtils.alert("\u5220\u9664\u5931\u8d25", PivotUtils.getParentFrame((JComponent)((Object)this)));
        }
    }

    private void onSetDefault() {
        String name = this.getSelectName();
        if (name == null) {
            PivotUtils.alert("\u6ca1\u6709\u9009\u62e9\u884c", PivotUtils.getParentFrame((JComponent)((Object)this)));
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("ui", this.uiDesc.id);
        try {
            this.service.setDefaultQuerySchema(name, params);
            this.loadTable(name);
        }
        catch (BOSException e) {
            e.printStackTrace();
            PivotUtils.alert("\u8bbe\u7f6e\u5931\u8d25", PivotUtils.getParentFrame((JComponent)((Object)this)));
        }
    }

    public boolean containsName(String name) {
        return this.names.contains(name);
    }

    public String getSelectName() {
        KDTSelectBlock block = this.table.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getTop();
            return this.table.getRow(rowIndex).getCell(0).getValue().toString();
        }
        return null;
    }

    public String getContent(String name) throws BOSException {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("ui", this.uiDesc.id);
        return this.service.getQuerySchemaContent(name, params);
    }

    public void saveContent(String name, String content) throws BOSException {
        String operate = this.containsName(name) ? "update" : "insert";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("ui", this.uiDesc.id);
        params.put("uiTitle", this.uiDesc.title);
        params.put("operate", operate);
        this.service.saveQuerySchema(name, content, params);
    }

    private void select(int rowIndex, boolean doubleClick) {
        if (this.listener != null) {
            String name = this.table.getRow(rowIndex).getCell(0).getValue().toString();
            this.listener.onSelect(doubleClick, name);
        }
    }

    public void addSelectListener(SelectListener l) {
        this.listener = l;
    }

    public static interface SelectListener {
        public void onSelect(boolean var1, String var2);
    }
}

