/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.columnbased;

import com.kingdee.bos.streamwork.columnbased.OnlyKeyMap;
import com.kingdee.bos.streamwork.columnbased.Vector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ShareObjectVector<T>
implements Vector<T>,
Serializable {
    private transient ArrayList<T> values = new ArrayList();
    private transient OnlyKeyMap<T> map = new OnlyKeyMap();
    private int cardinality;

    public ShareObjectVector() {
    }

    public ShareObjectVector(T[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            this.append(rows[i]);
        }
    }

    public ShareObjectVector(Iterator<T> iter) {
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    public ShareObjectVector(Collection<T> collection) {
        Iterator<T> iter = collection.iterator();
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public T get(int row) {
        return this.values.get(row);
    }

    @Override
    public void append(T o) {
        this.ensureMap();
        this.map.putKey(o);
        this.values.add(o);
    }

    @Override
    public void set(int index, T o) {
        this.ensureMap();
        if (this.map.containsKey(o)) {
            this.values.set(index, this.map.getKey(o));
        } else {
            this.map.putKey(o);
            this.values.set(index, o);
        }
    }

    @Override
    public int getCardinality() {
        if (this.map != null) {
            this.cardinality = this.map.size;
        }
        return this.cardinality;
    }

    @Override
    public double getFactor() {
        if (this.map != null) {
            this.cardinality = this.map.size;
        }
        return 1.0 * (double)this.cardinality / (double)this.values.size();
    }

    @Override
    public void markFinish() {
        if (this.map != null) {
            this.cardinality = this.map.size;
            this.map = null;
        }
    }

    public void ensureMap() {
        if (this.map == null) {
            this.map = new OnlyKeyMap(this.cardinality + 1);
            Iterator<T> iter = this.values.iterator();
            while (iter.hasNext()) {
                this.map.putKey(iter.next());
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.markFinish();
        int size = this.values.size();
        s.writeInt(size);
        s.writeInt(this.cardinality);
        for (int i = 0; i < size; ++i) {
            s.writeObject(this.values.get(i));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.cardinality = s.readInt();
        this.values = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object o = s.readObject();
            this.values.add(o);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    private class MyIterator<T>
    implements Iterator {
        int pos = 0;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < ShareObjectVector.this.values.size();
        }

        public T next() {
            Object t = ShareObjectVector.this.values.get(this.pos);
            ++this.pos;
            return (T)t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

