/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.columnbased;

import com.kingdee.bos.streamwork.columnbased.BitmapVector;
import com.kingdee.bos.streamwork.columnbased.CBTable;
import com.kingdee.bos.streamwork.columnbased.ShareObjectVector;
import com.kingdee.bos.streamwork.columnbased.SimpleCBTable;
import com.kingdee.bos.streamwork.columnbased.Vector;
import com.kingdee.bos.streamwork.columnbased.VectorConverter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class TableBuilder {
    public static CBTable buildResultSet(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] columnNames = new String[columnCount];
        int[] columnTypes = new int[columnCount];
        Vector[] vectors = new Vector[columnCount];
        for (int i2 = 0; i2 < columnCount; ++i2) {
            columnNames[i2] = rsmd.getColumnName(i2 + 1);
            columnTypes[i2] = rsmd.getColumnType(i2 + 1);
            vectors[i2] = TableBuilder.createDefaultVector(columnTypes[i2]);
        }
        int rowIndex = 0;
        int volv = 100;
        while (rs.next()) {
            for (i = 0; i < columnCount; ++i) {
                vectors[i].append(rs.getObject(i + 1));
                vectors[i] = VectorConverter.convert(vectors[i]);
            }
            if (rowIndex == volv - 1) {
                volv *= 3;
            }
            ++rowIndex;
        }
        for (i = 0; i < columnCount; ++i) {
            Vector vector2 = VectorConverter.convert(vectors[i]);
            System.out.println(columnNames[i] + " factor=" + vectors[i].getFactor() + ", cardinality=" + vectors[i].getCardinality() + ",size=" + vectors[i].getSize());
            if (vector2 != vectors[i]) {
                System.out.println(" converted  to " + vector2.getClass());
            } else {
                System.out.println(" is " + vectors[i].getClass());
            }
            vectors[i] = vector2;
            vectors[i].markFinish();
        }
        return new SimpleCBTable(columnNames, columnTypes, vectors);
    }

    public static Vector createDefaultVector(int dataType) {
        switch (dataType) {
            case -7: 
            case 4: 
            case 12: 
            case 16: {
                return new BitmapVector();
            }
        }
        return new ShareObjectVector();
    }
}

