/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.columnbased;

import com.kingdee.bos.streamwork.columnbased.BitmapVector;
import com.kingdee.bos.streamwork.columnbased.ShareObjectVector;
import com.kingdee.bos.streamwork.columnbased.Vector;

public class VectorConverter {
    public static Vector convert(Vector vector) {
        if (vector instanceof ShareObjectVector) {
            return VectorConverter.convertShareObjectVector((ShareObjectVector)vector);
        }
        if (vector instanceof BitmapVector) {
            return VectorConverter.convertBitmapVector((BitmapVector)vector);
        }
        return null;
    }

    public static boolean shouldConvertShareObjectVector(ShareObjectVector vector) {
        int cardinality = vector.getCardinality();
        int size = vector.getSize();
        int capacity1 = size * 4;
        int capacity2 = cardinality * 8 * (size % 64 == 0 ? size / 64 : size / 64 + 1);
        return capacity2 < capacity1;
    }

    public static boolean shouldConvertBitmapVector(BitmapVector vector) {
        int cardinality = vector.getCardinality();
        int size = vector.getSize();
        int capacity1 = size * 4;
        int capacity2 = cardinality * 8 * (size % 64 == 0 ? size / 64 : size / 64 + 1);
        return capacity2 > capacity1;
    }

    public static boolean shouldConvertVector(Vector vector) {
        if (vector instanceof ShareObjectVector) {
            return VectorConverter.shouldConvertShareObjectVector((ShareObjectVector)vector);
        }
        if (vector instanceof BitmapVector) {
            return VectorConverter.shouldConvertBitmapVector((BitmapVector)vector);
        }
        return false;
    }

    public static Vector convertShareObjectVector(ShareObjectVector vector) {
        if (VectorConverter.shouldConvertShareObjectVector(vector)) {
            return new BitmapVector(vector.iterator());
        }
        return vector;
    }

    public static Vector convertBitmapVector(BitmapVector vector) {
        if (VectorConverter.shouldConvertBitmapVector(vector)) {
            return new ShareObjectVector(vector.iterator());
        }
        return vector;
    }
}

