/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba;

import com.kingdee.bos.streamwork.cuba.CUBAConfig;
import com.kingdee.bos.streamwork.cuba.CUBADatabase;
import com.kingdee.bos.streamwork.cuba.CUBAEngine;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Connection;
import com.kingdee.bos.streamwork.cuba.def.SchemaDef;
import com.kingdee.bos.streamwork.cuba.def.SchemaLoader;
import com.kingdee.bos.streamwork.cuba.impl.ConnectionImpl;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public final class CUBADriver {
    public static Logger logger = Logger.getLogger(CUBADriver.class);

    public static Connection openConnection(InputStream schemaDefInputStream, Map param) throws CUBAException {
        return CUBADriver.openConnection(schemaDefInputStream, param, new CUBAConfig());
    }

    public static Connection openConnection(SchemaDef schemaDef, Map param) throws CUBAException {
        return CUBADriver.openConnection(schemaDef, param, new CUBAConfig());
    }

    public static Connection openConnection(InputStream schemaDefInputStream, Map param, CUBAConfig config) throws CUBAException {
        return CUBADriver.openConnection(SchemaLoader.load(schemaDefInputStream), param, config);
    }

    public static Connection openConnection(SchemaDef schemaDef, Map param, CUBAConfig config) throws CUBAException {
        try {
            return CUBADriver.openConnection(CUBAEngine.buildWithoutCheck(schemaDef, param, config));
        }
        catch (SQLException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Can't open olap connection.", (Throwable)e);
            }
            throw new CUBAException(e);
        }
    }

    public static Connection openConnection(CUBADatabase db) {
        return new ConnectionImpl(db);
    }
}

