/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.dbsource;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.dbsource.JdbcConnectionInfo;
import com.kingdee.bos.streamwork.cuba.def.ConnectionDef;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ConnectionHelper {
    public static Connection makeConnection(ConnectionDef def) throws CUBAException {
        ConnectionHelper.loadDriver(def.driver);
        Connection con = null;
        Properties prop = new Properties();
        if (def.user != null) {
            prop.put("user", def.user);
            prop.put("password", def.password);
        }
        try {
            con = DriverManager.getConnection(def.connectionString, prop);
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
        if (con == null) {
            throw new CUBAException("Can't connection to " + def.connectionString);
        }
        return con;
    }

    public static DataSource makeDataSource(Connection cn) {
        return new SimpleDataSource(cn);
    }

    public static Connection makeConnection(JdbcConnectionInfo cnInfo) throws CUBAException {
        String driver = cnInfo.getProperty("driver");
        ConnectionHelper.loadDriver(driver);
        String connectionString = cnInfo.getProperty("connection_string");
        String user = cnInfo.getProperty("user");
        String password = cnInfo.getProperty("password");
        Properties prop = new Properties();
        prop.put("user", user);
        prop.put("password", password);
        Connection con = null;
        try {
            con = DriverManager.getConnection(connectionString, prop);
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
        if (con == null) {
            throw new CUBAException("Can't connection to " + connectionString);
        }
        return con;
    }

    private static void loadDriver(String driver) throws CUBAException {
        if (driver == null) {
            return;
        }
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            throw new CUBAException("Jdbc driver is not found:" + driver);
        }
    }

    static class SimpleDataSource
    implements DataSource {
        private Connection con;

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        SimpleDataSource(Connection con) {
            this.con = con;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.con;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.con;
        }

        public boolean isWrapperFor(Class arg0) throws SQLException {
            return false;
        }

        public Object unwrap(Class arg0) throws SQLException {
            return null;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("TODO");
        }
    }
}

