/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.dbsource;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import com.kingdee.bos.streamwork.cuba.impl.Key;
import java.util.Hashtable;
import java.util.Vector;

public class MemoryTable
implements Table {
    String[] columnNames;
    int columnCount;
    int[] columnTypes;
    Hashtable indexs;
    Vector records;
    int row = -1;
    Object[] rowData = null;

    public MemoryTable(Table source) throws CUBAException {
        if (source instanceof MemoryTable) {
            MemoryTable m = (MemoryTable)source;
            this.columnNames = m.columnNames;
            this.columnCount = m.columnCount;
            this.columnTypes = m.columnTypes;
            this.indexs = m.indexs;
            this.records = m.records;
        } else {
            int i;
            this.columnCount = source.getColumnCount();
            this.columnNames = source.getColumnNames();
            this.columnTypes = new int[this.columnCount];
            for (i = 0; i < this.columnCount; ++i) {
                this.columnTypes[i] = source.getColumnType(i);
            }
            this.indexs = new Hashtable();
            for (i = 0; i < this.columnNames.length; ++i) {
                this.indexs.put(this.columnNames[i].toLowerCase(), new Integer(source.getColumnIndex(this.columnNames[i])));
            }
            this.records = new Vector();
            while (source.next()) {
                this.records.addElement(source.getValues());
            }
        }
        source.close();
    }

    public MemoryTable copy() throws CUBAException {
        return new MemoryTable(this);
    }

    @Override
    public String[] getColumnNames() throws CUBAException {
        return this.columnNames;
    }

    @Override
    public int getColumnCount() throws CUBAException {
        return this.columnCount;
    }

    @Override
    public int getColumnType(int index) throws CUBAException {
        return this.columnTypes[index];
    }

    @Override
    public int getColumnIndex(String name) throws CUBAException {
        Integer index = (Integer)this.indexs.get(name.toLowerCase());
        if (index == null) {
            throw new CUBAException("column '" + name + "' not found.");
        }
        return index;
    }

    @Override
    public boolean next() throws CUBAException {
        ++this.row;
        if (this.row < this.records.size()) {
            this.rowData = (Object[])this.records.elementAt(this.row);
            return true;
        }
        this.rowData = null;
        return false;
    }

    @Override
    public Object getValue(int index) throws CUBAException {
        return this.rowData[index];
    }

    @Override
    public Object[] getValues() throws CUBAException {
        return this.rowData;
    }

    public Object[] getRowData(int row) {
        return (Object[])this.records.elementAt(row);
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.row = -1;
    }

    public Index createIndex(String columns) throws CUBAException {
        return new Index(this, columns);
    }

    public class Index {
        public final Table source;
        public final String columns;
        Hashtable data;

        Index(Table _source, String _columns) throws CUBAException {
            this.source = _source;
            this.columns = _columns;
            Key key = new Key(this.source, this.columns);
            this.data = new Hashtable();
            MemoryTable.this.row = -1;
            while (MemoryTable.this.next()) {
                this.data.put(key.getCurrentValue(), new Integer(MemoryTable.this.row));
            }
        }

        public void moveTo(Object key) {
            Integer r = (Integer)this.data.get(key);
            if (r == null) {
                MemoryTable.this.row = -1;
                MemoryTable.this.rowData = new Object[MemoryTable.this.columnCount];
            } else {
                MemoryTable.this.row = r;
                MemoryTable.this.rowData = (Object[])MemoryTable.this.records.elementAt(MemoryTable.this.row);
            }
        }
    }
}

