/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.dbsource;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import com.kingdee.bos.streamwork.cuba.util.InOutSqlUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class ResultSetTable
implements Table {
    public final ResultSet rs;
    private ResultSetMetaData md;
    private Hashtable columns = new Hashtable();
    private String[] columnNames;
    private Object[] data;
    private static final Null nullObject = new Null();

    public ResultSetTable(ResultSet _rs) throws SQLException {
        this.rs = _rs;
        this.md = this.rs.getMetaData();
        Vector<String> v = new Vector<String>();
        for (int i = 1; i <= this.md.getColumnCount(); ++i) {
            String column = this.md.getColumnName(i);
            this.columns.put(column.toLowerCase(), new Integer(i - 1));
            v.addElement(column);
        }
        this.columnNames = new String[v.size()];
        v.copyInto(this.columnNames);
    }

    public ResultSetMetaData getMetaData() {
        return this.md;
    }

    public void nullData() {
        int size = this.columnNames.length;
        this.data = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = nullObject;
        }
    }

    @Override
    public String[] getColumnNames() throws CUBAException {
        return this.columnNames;
    }

    @Override
    public int getColumnCount() throws CUBAException {
        try {
            return this.md.getColumnCount();
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
    }

    @Override
    public int getColumnType(int index) throws CUBAException {
        try {
            return this.md.getColumnType(index + 1);
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
    }

    @Override
    public int getColumnIndex(String name) throws CUBAException {
        Integer index = (Integer)this.columns.get(name.toLowerCase());
        if (index == null) {
            throw new CUBAException("Column '" + name + "' not found.");
        }
        return index;
    }

    @Override
    public boolean next() throws CUBAException {
        try {
            this.nullData();
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
    }

    @Override
    public Object getValue(int index) throws CUBAException {
        if (this.data[index] != nullObject) {
            return this.data[index];
        }
        try {
            this.data[index] = InOutSqlUtil.getValue(this.rs, this.getColumnType(index), index + 1);
            return this.data[index];
        }
        catch (SQLException e) {
            throw new CUBAException(e);
        }
    }

    @Override
    public Object[] getValues() throws CUBAException {
        for (int i = 0; i < this.data.length; ++i) {
            if (nullObject != this.data[i]) continue;
            this.data[i] = this.getValue(i);
        }
        return this.data;
    }

    @Override
    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.rs.getStatement().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class Null {
        private Null() {
        }
    }
}

