/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.dbsource;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.dbsource.MemoryTable;
import com.kingdee.bos.streamwork.cuba.dbsource.ResultSetTable;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import com.kingdee.bos.streamwork.cuba.dbsource.TableManager;
import com.kingdee.bos.streamwork.cuba.dbsource.TableSourceBase;
import com.kingdee.bos.streamwork.cuba.def.CubeDef;
import com.kingdee.bos.streamwork.cuba.def.DimensionUsageDef;
import com.kingdee.bos.streamwork.cuba.def.SchemaDef;
import com.kingdee.bos.streamwork.cuba.def.TableDef;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TableDefTableSource
extends TableSourceBase {
    TableDef def;
    private static Logger logger = Logger.getLogger(TableDefTableSource.class);

    TableDefTableSource(TableManager manager, TableDef def) {
        super(manager);
        this.def = def;
    }

    public String[] getTableAndSql() {
        String tablename = null;
        String sql = null;
        if (this.def.sql == null) {
            tablename = this.def.name;
        } else if (this.def.sql.toLowerCase().indexOf("select") < 0) {
            tablename = this.def.sql;
        } else {
            StringTokenizer st = new StringTokenizer(this.def.sql, " \t\n\r\f,");
            int count = st.countTokens();
            if (count == 4 && "select".equalsIgnoreCase(st.nextToken())) {
                for (int i = 1; i < count - 2; ++i) {
                    st.nextToken();
                }
                if ("from".equalsIgnoreCase(st.nextToken())) {
                    tablename = st.nextToken();
                }
            }
        }
        if (tablename == null) {
            tablename = this.def.name + "_";
            sql = this.def.sql;
        }
        return new String[]{tablename, sql};
    }

    public void joinSql(SchemaDef schemaDef, CubeDef cubeDef) throws SQLException, CUBAException {
        String sql;
        String[] tableSql = this.getTableAndSql();
        String factTable = tableSql[0];
        String factSql = tableSql[1];
        ArrayList<String[]> dimList = new ArrayList<String[]>();
        for (int i = 0; i < cubeDef.dimensions.length; ++i) {
            DimensionUsageDef usage = (DimensionUsageDef)cubeDef.dimensions[i];
            String foreignKey = usage.foreignKey;
            String primaryKey = schemaDef.getDimensionDef((String)usage.name).primaryKey;
            String tableName = schemaDef.getDimensionDef((String)usage.name).table;
            TableDefTableSource tableSource = (TableDefTableSource)this.manager.getTableSource(tableName);
            tableSql = tableSource.getTableAndSql();
            dimList.add(new String[]{tableSql[0], tableSql[1], primaryKey, foreignKey});
        }
        StringBuilder sb = new StringBuilder("select ").append(factTable);
        StringBuilder join = new StringBuilder();
        if (factSql == null) {
            sb.append(".* from ").append(factTable);
        } else {
            sb.append(".* from (").append(factSql).append(") as ").append(factTable);
        }
        for (int i = 0; i < dimList.size(); ++i) {
            tableSql = (String[])dimList.get(i);
            if (tableSql[1] == null) {
                sb.append(",").append(tableSql[0]);
            } else {
                sb.append(", (").append(tableSql[1]).append(") ").append(tableSql[0]);
            }
            if (i > 0) {
                join.append(" and ");
            }
            join.append(factTable).append(".").append(tableSql[3]).append("=").append(tableSql[0]).append(".").append(tableSql[2]);
        }
        this.def.sql = sql = sb.toString() + " where " + join.toString();
    }

    @Override
    public Table createTable() throws SQLException, CUBAException {
        String sql = this.def.sql;
        if (sql.toLowerCase().indexOf("select") < 0) {
            sql = "select * from " + sql;
        }
        long time = System.currentTimeMillis();
        ResultSet rs = this.manager.executeQuery(sql);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("execute sql cost " + (System.currentTimeMillis() - time) + " ms. sql is \n" + sql));
        }
        this.table = new ResultSetTable(rs);
        if (this.ref > 1) {
            this.table = new MemoryTable(this.table);
        }
        return this.table;
    }
}

