/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.dbsource;

import com.kingdee.bos.streamwork.cuba.CUBAConfig;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.dbsource.ConnectionHelper;
import com.kingdee.bos.streamwork.cuba.dbsource.ResultSetTable;
import com.kingdee.bos.streamwork.cuba.dbsource.SqlWithParamTableDef;
import com.kingdee.bos.streamwork.cuba.dbsource.SqlWithParamTableSource;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import com.kingdee.bos.streamwork.cuba.dbsource.TableDefTableSource;
import com.kingdee.bos.streamwork.cuba.dbsource.TableSource;
import com.kingdee.bos.streamwork.cuba.dbsource.TableSourceBase;
import com.kingdee.bos.streamwork.cuba.def.ConnectionDef;
import com.kingdee.bos.streamwork.cuba.def.ParameterDef;
import com.kingdee.bos.streamwork.cuba.def.SchemaDef;
import com.kingdee.bos.streamwork.cuba.def.TableDef;
import com.kingdee.bos.streamwork.cuba.util.IgnoreCaseString;
import com.kingdee.bos.streamwork.cuba.util.SqlParamSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class TableManager {
    private static Logger log = Logger.getLogger(TableManager.class);
    Connection conn;
    HashMap tables = new HashMap();
    HashMap tableDefMap = new HashMap();

    public TableManager(SchemaDef def, Map params, CUBAConfig config) throws CUBAException, SQLException {
        int i;
        if (def.parameters != null) {
            for (i = 0; i < def.parameters.length; ++i) {
                ParameterDef param = def.parameters[i];
                Object x = params.get(param.name);
                if (x == null) {
                    x = params.get(new IgnoreCaseString(param.name));
                }
                if (x == null) {
                    throw new CUBAException("Parameter '" + param.name + "' has no data.");
                }
                if (!param.type.equalsIgnoreCase("Table")) continue;
                if (x instanceof Table) {
                    this.addTable(param.name, (Table)x);
                    continue;
                }
                if (x instanceof ResultSet) {
                    this.addTable(param.name, new ResultSetTable((ResultSet)x));
                    continue;
                }
                if (x instanceof String) {
                    this.addTable(param.name, (String)x);
                    continue;
                }
                if (x instanceof TableDef) {
                    this.addTable(param.name, new TableDefTableSource(this, (TableDef)x));
                    continue;
                }
                if (x instanceof SqlWithParamTableDef) {
                    this.addTable(param.name, new SqlWithParamTableSource(this, (SqlWithParamTableDef)x));
                    continue;
                }
                throw new CUBAException("Parameter '" + param.name + "'  not a ResultSet or Table.");
            }
        }
        if (def.connection != null) {
            this.setConnection(def.connection);
        } else {
            Object conn = params.get("JdbcConnection");
            Object ds = params.get("JdbcDataSource");
            if (conn != null) {
                if (!(conn instanceof Connection)) {
                    throw new CUBAException("Jdbc Connection must be java.sql.Connection");
                }
                this.setConnection((Connection)conn);
            } else if (ds != null) {
                if (!(ds instanceof DataSource)) {
                    throw new CUBAException("Jdbc DataSource must be javax.sql.DataSource");
                }
                this.setConnection(((DataSource)ds).getConnection());
            }
        }
        if (def.tables != null) {
            for (i = 0; i < def.tables.length; ++i) {
                TableDef t = def.tables[i];
                this.addTable(t);
            }
        }
        if (def.dimensions != null) {
            for (i = 0; i < def.dimensions.length; ++i) {
                if (def.dimensions[i].table == null) {
                    throw new CUBAException("Dimension " + def.dimensions[i].name + " no table defined.");
                }
                this.useTable(def.dimensions[i].table);
                this.getTableSource(def.dimensions[i].table).setUseCase("dimension");
            }
        }
        for (i = 0; i < def.cubes.length; ++i) {
            this.useTable(def.cubes[i].table);
            this.getTableSource(def.cubes[i].table).setUseCase("fact");
            if (!config.BUILD_AUTOJOINFACTSQL) continue;
            ((TableDefTableSource)this.getTableSource(def.cubes[i].table)).joinSql(def, def.cubes[i]);
        }
    }

    public void clear() {
        Object[] names = this.tables.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            TableSourceBase ts = this.getTableSource((String)names[i]);
            if (ts == null) continue;
            ts.close();
        }
        this.tables.clear();
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void setConnection(Connection cn) {
        this.conn = cn;
    }

    private void setConnection(ConnectionDef def) throws CUBAException {
        if (this.conn == null) {
            this.conn = ConnectionHelper.makeConnection(def);
        }
    }

    ResultSet executeQuery(String sql) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("No database connection.");
        }
        Statement stm = this.conn.createStatement();
        stm.setFetchSize(5000);
        return stm.executeQuery(sql);
    }

    ResultSet executeQuery(String sql, SqlParamSet sps) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("No database connection.");
        }
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ps.setFetchSize(5000);
        sps.putToStatement(ps);
        return ps.executeQuery();
    }

    private void addTable(String name, String sql) {
        this.addTable(name, new TableDefTableSource(this, new TableDef(name, sql)));
    }

    private void addTable(String name, Table table) {
        this.addTable(name, new TableSource(this, table));
    }

    private void addTable(TableDef def) {
        this.addTable(def.name, new TableDefTableSource(this, def));
    }

    private void addTable(String name, TableSourceBase source) {
        this.tables.put(name.toLowerCase(), source);
    }

    private boolean containsTable(String name) {
        return this.tables.containsKey(name);
    }

    void useTable(String name) {
        this.getTableSource(name).addUse();
    }

    public void releaseTable(String name) {
        TableSourceBase source = this.getTableSource(name);
        if (source == null) {
            return;
        }
        if (source.release()) {
            this.tables.remove(name);
        }
    }

    public TableSourceBase getTableSource(String name) {
        TableSourceBase ts = (TableSourceBase)this.tables.get(name.toLowerCase());
        if (ts == null) {
            this.addTable(name, name);
            return (TableSourceBase)this.tables.get(name.toLowerCase());
        }
        return ts;
    }

    public Table getTable(String name) throws SQLException, CUBAException {
        return this.getTableSource(name).get();
    }
}

