/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.def;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.def.AbstractCubeDimensionDef;
import com.kingdee.bos.streamwork.cuba.def.CalculatedMemberDef;
import com.kingdee.bos.streamwork.cuba.def.CalculatedMemberPropertyDef;
import com.kingdee.bos.streamwork.cuba.def.ConnectionDef;
import com.kingdee.bos.streamwork.cuba.def.CubeDef;
import com.kingdee.bos.streamwork.cuba.def.DimensionUsageDef;
import com.kingdee.bos.streamwork.cuba.def.HierarchyDef;
import com.kingdee.bos.streamwork.cuba.def.LevelDef;
import com.kingdee.bos.streamwork.cuba.def.MeasureDef;
import com.kingdee.bos.streamwork.cuba.def.MeasurePropertyDef;
import com.kingdee.bos.streamwork.cuba.def.ParameterDef;
import com.kingdee.bos.streamwork.cuba.def.PermissionDef;
import com.kingdee.bos.streamwork.cuba.def.PermissionItemDef;
import com.kingdee.bos.streamwork.cuba.def.PropertyDef;
import com.kingdee.bos.streamwork.cuba.def.SchemaDef;
import com.kingdee.bos.streamwork.cuba.def.SharedDimensionDef;
import com.kingdee.bos.streamwork.cuba.def.TableDef;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class SchemaParser {
    private static Logger log = Logger.getLogger(SchemaParser.class);

    public static SchemaDef parse(Document doc) throws CUBAException {
        log.debug((Object)"Parsing Schema ...");
        Element x = doc.getRootElement();
        if (!x.getName().equals("Schema")) {
            throw new CUBAException("Document is not a OLAP Schema.");
        }
        SchemaDef schemaDef = SchemaParser.parseSchema(x);
        log.debug((Object)"Parse succeeded.");
        return schemaDef;
    }

    private static SchemaDef parseSchema(Element x) throws CUBAException {
        SchemaDef schema = new SchemaDef();
        schema.name = x.getAttributeValue("name");
        schema.caption = x.getAttributeValue("caption");
        schema.description = x.getAttributeValue("description");
        List items = x.getChildren();
        Vector<ParameterDef> params = new Vector<ParameterDef>();
        Vector<TableDef> tables = new Vector<TableDef>();
        Vector<SharedDimensionDef> dims = new Vector<SharedDimensionDef>();
        Vector<CubeDef> cubes = new Vector<CubeDef>();
        ConnectionDef conn = null;
        for (int i = 0; i < items.size(); ++i) {
            Element item = (Element)items.get(i);
            String itemName = item.getName();
            if (itemName.equals("Config")) {
                SchemaParser.parseConfig(schema.config, item);
                continue;
            }
            if (itemName.equals("Parameter")) {
                params.addElement(SchemaParser.parseParameter(item));
                continue;
            }
            if (itemName.equals("Connection")) {
                conn = SchemaParser.parseConnection(item);
                continue;
            }
            if (itemName.equals("Table")) {
                tables.addElement(SchemaParser.parseTable(item));
                continue;
            }
            if (itemName.equals("Dimension")) {
                dims.addElement(SchemaParser.parseShareDimension(item));
                continue;
            }
            if (itemName.equals("Cube")) {
                cubes.addElement(SchemaParser.parseCube(item));
                continue;
            }
            throw new CUBAException("Element type '" + itemName + "' not supported.");
        }
        schema.parameters = new ParameterDef[params.size()];
        params.copyInto(schema.parameters);
        schema.connection = conn;
        schema.tables = new TableDef[tables.size()];
        tables.copyInto(schema.tables);
        schema.dimensions = new SharedDimensionDef[dims.size()];
        dims.copyInto(schema.dimensions);
        schema.cubes = new CubeDef[cubes.size()];
        cubes.copyInto(schema.cubes);
        return schema;
    }

    private static void parseConfig(Properties config, Element x) throws CUBAException {
        List items = x.getChildren("Item");
        for (int i = 0; i < items.size(); ++i) {
            Element item = (Element)items.get(i);
            String name = item.getAttributeValue("name");
            String value = item.getAttributeValue("value");
            if (name == null || value == null) {
                throw new CUBAException("Config item name or value undefined.");
            }
            config.setProperty(name, value);
        }
    }

    private static ParameterDef parseParameter(Element x) throws CUBAException {
        ParameterDef param = new ParameterDef();
        param.name = x.getAttributeValue("name");
        param.type = x.getAttributeValue("type");
        return param;
    }

    private static ConnectionDef parseConnection(Element x) throws CUBAException {
        ConnectionDef cn = new ConnectionDef();
        cn.name = x.getAttributeValue("name");
        cn.driver = x.getAttributeValue("driver");
        cn.connectionString = x.getAttributeValue("connectionString");
        cn.user = x.getAttributeValue("user");
        cn.password = x.getAttributeValue("password");
        return cn;
    }

    private static TableDef parseTable(Element x) throws CUBAException {
        TableDef table = new TableDef();
        table.name = x.getAttributeValue("name");
        table.sql = x.getAttributeValue("sql");
        return table;
    }

    private static SharedDimensionDef parseShareDimension(Element x) throws CUBAException {
        SharedDimensionDef dim = new SharedDimensionDef();
        dim.name = x.getAttributeValue("name");
        dim.caption = x.getAttributeValue("caption");
        dim.description = x.getAttributeValue("description");
        dim.type = x.getAttributeValue("type");
        dim.table = x.getAttributeValue("table");
        dim.primaryKey = x.getAttributeValue("primaryKey");
        ArrayList<HierarchyDef> hies = new ArrayList<HierarchyDef>();
        List items = x.getChildren("Hierarchy");
        for (int i = 0; i < items.size(); ++i) {
            hies.add(SchemaParser.parseHierarchy((Element)items.get(i)));
        }
        dim.hierarchies = new HierarchyDef[hies.size()];
        hies.toArray(dim.hierarchies);
        Element element = x.getChild("Permission");
        if (element != null) {
            dim.permission = SchemaParser.parsePermission(dim.name, element);
        }
        return dim;
    }

    private static PermissionDef parsePermission(String parent, Element x) throws CUBAException {
        PermissionDef per = new PermissionDef();
        per.type = x.getAttributeValue("type");
        ArrayList<Object> items = new ArrayList<Object>();
        List children = x.getChildren("Item");
        for (int i = 0; i < children.size(); ++i) {
            items.add(SchemaParser.parsePermissionItem((Element)children.get(i)));
        }
        per.items = new PermissionItemDef[children.size()];
        items.toArray(per.items);
        return per;
    }

    private static Object parsePermissionItem(Element x) {
        PermissionItemDef item = new PermissionItemDef();
        item.type = x.getAttributeValue("type");
        item.name = x.getAttributeValue("name");
        item.column = x.getAttributeValue("column");
        return item;
    }

    private static CubeDef parseCube(Element x) throws CUBAException {
        CubeDef cube = new CubeDef();
        cube.name = x.getAttributeValue("name");
        cube.caption = x.getAttributeValue("caption");
        cube.description = x.getAttributeValue("description");
        cube.table = x.getAttributeValue("table");
        cube.measureDimensionCaption = x.getAttributeValue("measureDimensionCaption");
        Vector<MeasureDef> measures = new Vector<MeasureDef>();
        Vector<PropertyDef> properties = new Vector<PropertyDef>();
        Vector<CalculatedMemberDef> calculatedMembers = new Vector<CalculatedMemberDef>();
        Vector<DimensionUsageDef> dims = new Vector<DimensionUsageDef>();
        List items = x.getChildren();
        for (int i = 0; i < items.size(); ++i) {
            Element item = (Element)items.get(i);
            String itemName = item.getName();
            if (itemName.equals("DimensionUsage")) {
                dims.addElement(SchemaParser.parseDimensionUsage(item));
                continue;
            }
            if (itemName.equals("Measure")) {
                measures.addElement(SchemaParser.parseMeasure(item));
                continue;
            }
            if (itemName.equals("Property")) {
                properties.addElement(SchemaParser.parseProperty(item));
                continue;
            }
            if (itemName.equals("CalculatedMember")) {
                calculatedMembers.addElement(SchemaParser.parseCalculatedMember(item));
                continue;
            }
            throw new CUBAException("Unknown type '" + itemName + "' in cube '" + cube.name + "'");
        }
        cube.dimensions = new AbstractCubeDimensionDef[dims.size()];
        dims.copyInto(cube.dimensions);
        cube.measures = new MeasureDef[measures.size()];
        measures.copyInto(cube.measures);
        cube.properties = new PropertyDef[properties.size()];
        properties.copyInto(cube.properties);
        cube.calculatedMembers = new CalculatedMemberDef[calculatedMembers.size()];
        calculatedMembers.copyInto(cube.calculatedMembers);
        return cube;
    }

    private static CalculatedMemberDef parseCalculatedMember(Element x) {
        CalculatedMemberDef def = new CalculatedMemberDef();
        def.name = x.getAttributeValue("name");
        def.caption = x.getAttributeValue("caption");
        def.solveOrder = x.getAttributeValue("solveOrder");
        def.dimension = x.getAttributeValue("dimension");
        def.formula = x.getAttributeValue("formula");
        def.formatString = x.getAttributeValue("formatString");
        def.color = x.getAttributeValue("color");
        def.bgColor = x.getAttributeValue("bgColor");
        def.trend = x.getAttributeValue("trend");
        def.status = x.getAttributeValue("status");
        String visible = x.getAttributeValue("visible");
        def.visible = !"false".equalsIgnoreCase(visible);
        Vector<CalculatedMemberPropertyDef> v = new Vector<CalculatedMemberPropertyDef>();
        List items = x.getChildren("Property");
        for (int i = 0; i < items.size(); ++i) {
            v.addElement(SchemaParser.parseCalculatedMemberProperty((Element)items.get(i)));
        }
        def.properties = new CalculatedMemberPropertyDef[items.size()];
        v.copyInto(def.properties);
        return def;
    }

    private static CalculatedMemberPropertyDef parseCalculatedMemberProperty(Element x) {
        CalculatedMemberPropertyDef def = new CalculatedMemberPropertyDef();
        def.name = x.getAttributeValue("name");
        def.value = x.getAttributeValue("value");
        return def;
    }

    private static MeasurePropertyDef parseMeasureProperty(Element x) {
        MeasurePropertyDef def = new MeasurePropertyDef();
        def.name = x.getAttributeValue("name");
        def.value = x.getAttributeValue("value");
        return def;
    }

    private static DimensionUsageDef parseDimensionUsage(Element x) throws CUBAException {
        DimensionUsageDef dim = new DimensionUsageDef();
        dim.name = x.getAttributeValue("name");
        dim.foreignKey = x.getAttributeValue("foreignKey");
        return dim;
    }

    private static MeasureDef parseMeasure(Element x) throws CUBAException {
        String v;
        MeasureDef measure = new MeasureDef();
        measure.name = x.getAttributeValue("name");
        measure.caption = x.getAttributeValue("caption");
        measure.description = x.getAttributeValue("description");
        measure.column = x.getAttributeValue("column");
        measure.aggregator = x.getAttributeValue("aggregator");
        measure.formatString = x.getAttributeValue("formatString");
        measure.bgColor = x.getAttributeValue("bgColor");
        measure.color = x.getAttributeValue("color");
        measure.trend = x.getAttributeValue("trend");
        measure.status = x.getAttributeValue("status");
        if ("".equals(measure.color)) {
            measure.color = null;
        }
        if ("".equals(measure.bgColor)) {
            measure.bgColor = null;
        }
        if ("".equals(measure.trend)) {
            measure.trend = null;
        }
        if ("".equals(measure.status)) {
            measure.status = null;
        }
        measure.visible = !"false".equalsIgnoreCase(v = x.getAttributeValue("visible"));
        Element element = x.getChild("Permission");
        if (element != null) {
            measure.permission = SchemaParser.parsePermission(measure.name, element);
        }
        Vector<MeasurePropertyDef> vector = new Vector<MeasurePropertyDef>();
        List items = x.getChildren("Property");
        for (int i = 0; i < items.size(); ++i) {
            vector.addElement(SchemaParser.parseMeasureProperty((Element)items.get(i)));
        }
        measure.properties = new MeasurePropertyDef[items.size()];
        vector.copyInto(measure.properties);
        return measure;
    }

    private static HierarchyDef parseHierarchy(Element x) throws CUBAException {
        String aggregate;
        HierarchyDef hie = new HierarchyDef();
        hie.hasAll = false;
        hie.name = x.getAttributeValue("name");
        hie.caption = x.getAttributeValue("caption");
        hie.description = x.getAttributeValue("description");
        String hasAll = x.getAttributeValue("hasAll");
        if (hasAll != null) {
            if (hasAll.equalsIgnoreCase("True")) {
                hie.hasAll = true;
            } else if (hasAll.equalsIgnoreCase("False")) {
                hie.hasAll = false;
            } else {
                throw new CUBAException("Hiearchy hasAll property value must be 'true' or 'false'.");
            }
        }
        if ((aggregate = x.getAttributeValue("aggregate")) != null) {
            if (aggregate.equalsIgnoreCase("True")) {
                hie.aggregate = true;
            } else if (aggregate.equalsIgnoreCase("False")) {
                hie.aggregate = false;
            } else {
                throw new CUBAException("Hiearchy aggregate property value must be 'true' or 'false'.");
            }
        }
        hie.allMemberName = x.getAttributeValue("allMemberName");
        hie.allMemberCaption = x.getAttributeValue("allMemberCaption");
        hie.v$AllMemberCaption = x.getAttributeValue("virtualAllMemberCaption");
        Vector<LevelDef> levels = new Vector<LevelDef>();
        List items = x.getChildren("Level");
        for (int i = 0; i < items.size(); ++i) {
            levels.addElement(SchemaParser.parseLevel((Element)items.get(i)));
        }
        hie.levels = new LevelDef[levels.size()];
        levels.copyInto(hie.levels);
        return hie;
    }

    private static LevelDef parseLevel(Element x) throws CUBAException {
        LevelDef level = new LevelDef();
        level.name = x.getAttributeValue("name");
        level.caption = x.getAttributeValue("caption");
        level.description = x.getAttributeValue("description");
        level.type = x.getAttributeValue("type");
        level.column = x.getAttributeValue("column");
        level.isDateTimeColumn = x.getAttributeValue("isDateTimeColumn");
        if (level.isDateTimeColumn == null) {
            level.isDateTimeColumn = "true";
        }
        level.orderBy = x.getAttributeValue("orderBy");
        level.orderMethod = x.getAttributeValue("orderMethod");
        level.childColumn = x.getAttributeValue("childColumn");
        level.parentColumn = x.getAttributeValue("parentColumn");
        level.dataType = x.getAttributeValue("dataType");
        level.closureDataType = x.getAttributeValue("closureDataType");
        level.rule = x.getAttributeValue("rule");
        String temp = x.getAttributeValue("maxDepth");
        if (temp != null) {
            level.maxDepth = Integer.parseInt(temp);
        }
        Vector<PropertyDef> props = new Vector<PropertyDef>();
        List items = x.getChildren("Property");
        for (int i = 0; i < items.size(); ++i) {
            props.addElement(SchemaParser.parseProperty((Element)items.get(i)));
        }
        level.properties = new PropertyDef[props.size()];
        props.copyInto(level.properties);
        return level;
    }

    private static PropertyDef parseProperty(Element x) throws CUBAException {
        PropertyDef prop = new PropertyDef();
        prop.name = x.getAttributeValue("name");
        prop.caption = x.getAttributeValue("caption");
        prop.description = x.getAttributeValue("description");
        prop.column = x.getAttributeValue("column");
        prop.dataType = x.getAttributeValue("dataType");
        return prop;
    }
}

