/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private T[] array;
    private int index = 0;
    private boolean lastRemoved = false;

    public ArrayIterator(T[] array) {
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.length;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (this.index >= this.array.length) {
            throw new NoSuchElementException("Array index: " + this.index);
        }
        T object = this.array[this.index];
        ++this.index;
        this.lastRemoved = false;
        return object;
    }

    @Override
    public void remove() {
        if (this.index == 0) {
            throw new IllegalStateException();
        }
        if (this.lastRemoved) {
            throw new IllegalStateException();
        }
        this.array[this.index - 1] = null;
        this.lastRemoved = true;
    }
}

