/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import com.kingdee.bos.streamwork.cuba.CUBAConfig;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import com.kingdee.bos.streamwork.cuba.def.DimensionUsageDef;
import com.kingdee.bos.streamwork.cuba.impl.DimensionBuildResult;
import com.kingdee.bos.streamwork.cuba.impl.DimensionFetch;
import com.kingdee.bos.streamwork.cuba.impl.DimensionImpl;
import com.kingdee.bos.streamwork.cuba.impl.Key;
import com.kingdee.bos.streamwork.cuba.impl.MemberImpl;

class DimensionUsageFetch
implements DimensionFetch {
    Key foreignKey = null;
    String foreignKeyName;
    DimensionBuildResult dbr;
    DimensionImpl dim;
    MemberImpl[] values;
    int hieCount;
    CUBAConfig config;

    DimensionUsageFetch(DimensionBuildResult dbr, DimensionImpl dim, DimensionUsageDef def, CUBAConfig config) {
        this.dim = dim;
        this.hieCount = dim.hies.length;
        this.foreignKeyName = def.foreignKey;
        this.dbr = dbr;
        this.config = config;
        this.values = new MemberImpl[this.hieCount];
    }

    @Override
    public MemberImpl[] fetch(Table table) throws CUBAException {
        if (this.foreignKey == null) {
            this.foreignKey = new Key(table, this.foreignKeyName);
        }
        Object keyValue = this.foreignKey.getCurrentValue();
        for (int i = 0; i < this.hieCount; ++i) {
            if (keyValue == null) {
                if (this.config.BUILD_FACT_IGNORENULLOTHER) {
                    return this.values;
                }
                this.values[i] = (MemberImpl)this.dim.hies[i].getInnerNullMember();
                continue;
            }
            this.values[i] = this.dbr.getHierarchyBuildResult(i).get(keyValue);
            if (this.values[i] != null) continue;
            if (this.config.BUILD_FACT_IGNORENULLOTHER) {
                return this.values;
            }
            this.values[i] = (MemberImpl)this.dim.hies[i].getInnerOtherMember();
        }
        return this.values;
    }

    @Override
    public void finish() {
    }
}

