/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import com.kingdee.bos.streamwork.cuba.CUBAElement;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Dimension;
import com.kingdee.bos.streamwork.cuba.Hierarchy;
import com.kingdee.bos.streamwork.cuba.Level;
import com.kingdee.bos.streamwork.cuba.Property;
import com.kingdee.bos.streamwork.cuba.collection.DefaultListFactory;
import com.kingdee.bos.streamwork.cuba.collection.IMemberList;
import com.kingdee.bos.streamwork.cuba.def.LevelDef;
import com.kingdee.bos.streamwork.cuba.impl.CubaElementBase;
import com.kingdee.bos.streamwork.cuba.impl.HierarchyImpl;
import com.kingdee.bos.streamwork.cuba.impl.MemberImpl;
import com.kingdee.bos.streamwork.cuba.impl.MemberIndex;
import com.kingdee.bos.streamwork.cuba.impl.PropertyImpl;
import com.kingdee.bos.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.bos.streamwork.cuba.mdx.type.LevelType;
import com.kingdee.bos.streamwork.cuba.mdx.type.Type;
import com.kingdee.bos.streamwork.cuba.util.UniqueNameUtil;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class LevelImpl
extends CubaElementBase
implements Level {
    public static final long serialVersionUID = 348765589877547547L;
    static final Logger logger = Logger.getLogger(HierarchyImpl.class);
    private transient String uniqueName;
    HierarchyImpl hie;
    byte levelType = 0;
    byte depth = 0;
    PropertyImpl[] props;
    LevelImpl child;
    LevelImpl parent;
    private transient MemberImpl[] members = null;
    private transient MemberIndex memberIndex;

    LevelImpl() {
    }

    @Override
    public Property[] getMemberProperties() {
        return this.props;
    }

    @Override
    public Level getChildLevel() {
        return this.child;
    }

    LevelImpl createChildLevel() {
        if (this.child == null) {
            this.child = new LevelImpl();
            this.child.hie = this.hie;
            this.child.levelType = this.levelType;
            this.child.depth = (byte)(this.depth + 1);
            this.child.props = this.props;
            this.child.parent = this;
            this.child.name = "Level #" + (this.depth + 1);
            if (this.child.hie.depth < this.depth + 1) {
                this.child.hie.depth = this.depth + 1;
            }
        }
        return this.child;
    }

    @Override
    public Level getParentLevel() {
        return this.parent;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hie;
    }

    @Override
    public byte getDepth() {
        return this.depth;
    }

    @Override
    public byte getLevelType() {
        return this.levelType;
    }

    public Type getExpType() {
        return new LevelType(this.hie, this);
    }

    public int getCategory() {
        return 4;
    }

    public synchronized void createMembers() {
        if (this.members != null) {
            return;
        }
        IMemberList result = DefaultListFactory.instance.createMemberList();
        LinkedList tempList = new LinkedList();
        if (this.hie.getMembers() != null) {
            Iterator iter = this.hie.getMembers().iterator();
            while (iter.hasNext()) {
                tempList.add(iter.next());
            }
        }
        while (tempList.size() > 0) {
            int i;
            MemberImpl[] children;
            MemberImpl m = (MemberImpl)tempList.removeFirst();
            byte depth2 = m.getLevel().getDepth();
            if (depth2 == this.depth) {
                result.add(m);
                continue;
            }
            if (depth2 >= this.depth || (children = m.getChildren()) == null) continue;
            if (depth2 == this.depth - 1) {
                for (i = 0; i < children.length; ++i) {
                    result.add(children[i]);
                }
                continue;
            }
            for (i = 0; i < children.length; ++i) {
                tempList.addFirst(children[i]);
            }
        }
        this.members = new MemberImpl[result.size()];
        result.toArray(this.members);
    }

    public IMemberList getMemberList() {
        if (this.members == null) {
            this.createMembers();
        }
        return DefaultListFactory.instance.createMemberList(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CUBAElement lookupChild(SchemaReader schemaReader, String name) throws CUBAException {
        if (this.memberIndex == null) {
            LevelImpl levelImpl = this;
            synchronized (levelImpl) {
                this.memberIndex = new MemberIndex(false);
                if (this.members == null) {
                    this.createMembers();
                }
                MemberImpl found = null;
                for (int i = 0; i < this.members.length; ++i) {
                    MemberImpl m = this.members[i];
                    if (!m.getName().equals(name)) continue;
                    this.memberIndex.put(name, m);
                    found = m;
                }
                return found;
            }
        }
        return this.memberIndex.get(name);
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = UniqueNameUtil.makeUniqueName(this.hie, this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public boolean isAll() {
        return this.levelType == -1;
    }

    @Override
    public boolean isMeasures() {
        return this.levelType == -2;
    }

    @Override
    public Dimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            if (this.isAll()) {
                return "All";
            }
            return "Level #" + (this.depth + 1);
        }
        return name;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    public LevelDef getLevelDef() {
        return null;
    }
}

