/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.impl;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.RollupPolicy;
import com.kingdee.bos.streamwork.cuba.impl.RollupMemCubeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RollupManager {
    private RollupPolicy rollupPolicy;
    private RollupMemCubeData rollupMemCubeData;
    private List<Node> lowNodes = null;
    private HashMap<Key, Node> nodeMap = new HashMap();
    private int[] tempKeys = new int[64];
    private Member[] tempMembers = null;

    public RollupManager(RollupPolicy rollupPolicy, RollupMemCubeData rollupMemCubeData) {
        this.rollupPolicy = rollupPolicy;
        this.init();
        this.rollupMemCubeData = rollupMemCubeData;
    }

    private void init() {
        int[] rows = this.rollupPolicy.rows;
        int[] columns = this.rollupPolicy.columns;
        if (rows == null && columns == null) {
            return;
        }
        this.lowNodes = columns == null ? this.initOne(rows, 0) : (rows == null ? this.initOne(columns, 1) : this.initBoth(rows, columns));
    }

    private List<Node> initOne(int[] rows, int rowOrColumn) {
        boolean showTotal = false;
        boolean showSubTotal = false;
        if (rowOrColumn == 0) {
            showTotal = this.rollupPolicy.showTotalOnRow;
            showSubTotal = this.rollupPolicy.showSubTotalOnRow;
        } else if (rowOrColumn == 1) {
            showTotal = this.rollupPolicy.showTotalOnColumn;
            showSubTotal = this.rollupPolicy.showSubTotalOnColumn;
        }
        ArrayList<Node> lowNodes = new ArrayList<Node>();
        Node child = null;
        for (int i = rows.length - 1; i >= 0; --i) {
            if (showTotal && !showSubTotal && rows.length > 1 && i > 0 || !showTotal && showSubTotal && rows.length > 1 && i == 0) continue;
            int[] index = new int[rows.length - i];
            for (int j = i; j < rows.length; ++j) {
                index[j - i] = rows[j];
            }
            Node node = new Node(index, rowOrColumn);
            node.map = new HashMap<Point, Object[]>();
            if (child != null) {
                child.parentNodes.add(node);
            } else {
                lowNodes.add(node);
            }
            child = node;
        }
        return lowNodes;
    }

    private List<Node> initBoth(int[] rows, int[] columns) {
        List<Node> lowNodes1 = this.initOne(rows, 0);
        List<Node> lowNodes2 = this.initOne(columns, 1);
        ArrayList<Node> lowNodes = new ArrayList<Node>();
        lowNodes.addAll(lowNodes1);
        lowNodes.addAll(lowNodes2);
        for (int i = 0; i < lowNodes1.size(); ++i) {
            Node node1 = lowNodes1.get(i);
            for (int j = 0; j < lowNodes2.size(); ++j) {
                Node node2 = lowNodes2.get(j);
                lowNodes.add(this.addParentNodes(node1, node2, lowNodes));
            }
        }
        return lowNodes;
    }

    private Node addParentNodes(Node node1, Node node2, List<Node> lowNodes) {
        Node newNode;
        int[] indexes = new int[node1.indexs.length + node2.indexs.length];
        System.arraycopy(node1.indexs, 0, indexes, 0, node1.indexs.length);
        System.arraycopy(node2.indexs, 0, indexes, node1.indexs.length, node2.indexs.length);
        Node node3 = new Node(indexes, 2);
        Iterator<Node> iter = node2.parentNodes.iterator();
        while (iter.hasNext()) {
            newNode = this.addParentNodes(node1, iter.next(), lowNodes);
            node3.parentNodes.add(newNode);
        }
        iter = node1.parentNodes.iterator();
        while (iter.hasNext()) {
            newNode = this.addParentNodes(iter.next(), node2, lowNodes);
            node3.parentNodes.add(newNode);
        }
        return node3;
    }

    public Object[] getData(Member[] members) {
        int len = 0;
        if (this.tempMembers == null) {
            this.tempMembers = new Member[members.length];
        }
        System.arraycopy(members, 0, this.tempMembers, 0, members.length);
        for (int i = 0; i < members.length; ++i) {
            if (members[i] != null) continue;
            this.tempKeys[len++] = i;
        }
        if (len == 0) {
            return null;
        }
        int[] keys = new int[len];
        System.arraycopy(this.tempKeys, 0, keys, 0, len);
        Key key = new Key(keys);
        Node node = this.nodeMap.get(key);
        return node.map.get(new Point(this.tempMembers));
    }

    public void addRecord(Member[] members, Object[] values) throws CUBAException {
        if (this.lowNodes != null) {
            Iterator<Node> iter = this.lowNodes.iterator();
            while (iter.hasNext()) {
                this.addRecord(members, values, iter.next());
            }
        }
    }

    private void addRecord(Member[] members, Object[] values, Node node) throws CUBAException {
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, members.length);
        for (int i = 0; i < node.indexs.length; ++i) {
            ms[node.indexs[i]] = null;
        }
        Point point = new Point(ms);
        Object[] vs = node.map.get(point);
        vs = this.rollupMemCubeData.appendValue(vs, values);
        node.map.put(point, vs);
        Iterator<Node> iter = node.parentNodes.iterator();
        while (iter.hasNext()) {
            this.addRecord(members, values, iter.next());
        }
    }

    class Point {
        Member[] ms;

        Point(Member[] ms) {
            this.ms = ms;
        }

        public int hashCode() {
            int h = 0;
            for (int i = 0; i < this.ms.length; ++i) {
                h ^= this.ms[i] == null ? 37 : this.ms[i].hashCode();
            }
            return h;
        }

        public boolean equals(Object x) {
            Member[] ms2 = ((Point)x).ms;
            for (int i = 0; i < ms2.length; ++i) {
                if (ms2[i] == this.ms[i]) continue;
                return false;
            }
            return true;
        }
    }

    class Key {
        int[] keys;

        Key(int[] keys) {
            this.keys = keys;
        }

        public int hashCode() {
            int h = 0;
            for (int i = 0; i < this.keys.length; ++i) {
                h += this.keys[i] * 7;
            }
            return h;
        }

        public boolean equals(Object x) {
            int[] o = ((Key)x).keys;
            if (this.keys.length != o.length) {
                return false;
            }
            for (int i = 0; i < o.length; ++i) {
                if (this.keys[i] == o[i]) continue;
                return false;
            }
            return true;
        }
    }

    class Node {
        int rowOrColumn;
        ArrayList<Node> parentNodes = new ArrayList(1);
        int[] indexs;
        Map<Point, Object[]> map = new HashMap<Point, Object[]>();

        Node(int[] indexs, int rowOrColumn) {
            this.indexs = indexs;
            this.rowOrColumn = rowOrColumn;
            RollupManager.this.nodeMap.put(new Key(indexs), this);
        }
    }
}

