/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.mdx.DimensionProperty;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.ExpResolver;
import com.kingdee.bos.streamwork.cuba.mdx.Formula;
import com.kingdee.bos.streamwork.cuba.mdx.MdxQuery;
import com.kingdee.bos.streamwork.cuba.mdx.MemberProperty;
import com.kingdee.bos.streamwork.cuba.mdx.QueryAxis;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class StackExpResolver
implements ExpResolver {
    private final Stack stack = new Stack();
    private Set resolvedNodes = new HashSet();
    private MdxQuery query;

    public StackExpResolver(MdxQuery query) {
        this.query = query;
    }

    @Override
    public MdxQuery getQuery() {
        return this.query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exp resolve(Exp exp) throws CUBAException {
        if (!this.resolvedNodes.add(exp)) {
            return exp;
        }
        this.stack.push(exp);
        try {
            Exp resolved = exp.resolve(this);
            this.resolvedNodes.add(resolved);
            Exp exp2 = resolved;
            return exp2;
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void resolve(MemberProperty memberProperty) throws CUBAException {
        if (!this.resolvedNodes.add(memberProperty)) {
            return;
        }
        this.stack.push(memberProperty);
        try {
            memberProperty.resolve(this);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void resolve(DimensionProperty dimensionProperty) throws CUBAException {
        if (!this.resolvedNodes.add(dimensionProperty)) {
            return;
        }
        this.stack.push(dimensionProperty);
        try {
            dimensionProperty.resolve(this);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void resolve(QueryAxis axis) throws CUBAException {
        if (!this.resolvedNodes.add(axis)) {
            return;
        }
        this.stack.push(axis);
        try {
            axis.resolve(this);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void resolve(Formula formula) throws CUBAException {
        if (!this.resolvedNodes.add(formula)) {
            return;
        }
        this.stack.push(formula);
        try {
            formula.resolve(this);
        }
        finally {
            this.stack.pop();
        }
    }
}

