/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.calc.impl;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.FunCall;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Scope;
import com.kingdee.bos.streamwork.cuba.mdx.type.Type;

public abstract class AbstractCalc
implements Calc {
    protected Type type;
    protected Exp exp;

    protected AbstractCalc(Exp exp) {
        this.exp = exp;
        if (exp != null) {
            this.type = exp.getType();
        }
    }

    @Override
    public Type getType() {
        return this.type;
    }

    protected String getName() {
        String name;
        if (this.exp != null && this.exp instanceof FunCall) {
            FunCall funCall = (FunCall)this.exp;
            name = funCall.getFunDef().getName();
        } else {
            int dollar;
            name = this.getClass().getName();
            int dot = name.lastIndexOf(46);
            int dotDollar = Math.max(dot, dollar = name.lastIndexOf(36));
            if (dotDollar >= 0) {
                name = name.substring(dotDollar + 1);
            }
        }
        return name;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws CUBAException {
        Calc[] calcs = this.getCalcs();
        if (calcs != null) {
            for (int i = 0; i < calcs.length; ++i) {
                if (calcs[i] == null) continue;
                calcs[i] = calcs[i].optimize(scope, evaluator);
            }
        }
        return this;
    }
}

