/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Dimension;
import com.kingdee.bos.streamwork.cuba.Hierarchy;
import com.kingdee.bos.streamwork.cuba.collection.IMemberList;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.DimensionCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.DummyExp;
import com.kingdee.bos.streamwork.cuba.mdx.calc.HierarchyCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Scope;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractMemberListCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.ConstantCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.HierarchyMembersCalc;
import com.kingdee.bos.streamwork.cuba.mdx.func.FuncUtil2;
import com.kingdee.bos.streamwork.cuba.mdx.type.MemberType;
import com.kingdee.bos.streamwork.cuba.mdx.type.SetType;

public class DimensionMembersCalc
extends AbstractMemberListCalc {
    DimensionCalc dimensionCalc;
    boolean needNonEmpty = false;
    Scope.NeedHierarchize needHierarchize = Scope.NeedHierarchize.Yes;

    public DimensionMembersCalc(Exp exp, DimensionCalc dimensionCalc) {
        super(exp, new Calc[]{dimensionCalc});
        this.dimensionCalc = dimensionCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws CUBAException {
        this.needNonEmpty = scope.isNeedNonEmpty();
        this.needHierarchize = scope.getNeedHierarchize();
        Dimension dim = this.dimensionCalc.evaluateDimension(evaluator);
        HierarchyCalc calc = ConstantCalc.constantHierarchy(dim.getDefaultHierarchy());
        return new HierarchyMembersCalc((Exp)new DummyExp(new SetType(MemberType.forHierarchy(dim.getDefaultHierarchy()))), calc);
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws CUBAException {
        Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
        Hierarchy hierarchy = dimension.getDefaultHierarchy();
        IMemberList members = FuncUtil2.getHierarchizeMembers(evaluator.getSchemaReader(), hierarchy, this.needHierarchize != Scope.NeedHierarchize.No);
        if (this.needNonEmpty) {
            members = FuncUtil2.nonFactEmptyMembers(evaluator, members);
        }
        return members;
    }
}

