/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Hierarchy;
import com.kingdee.bos.streamwork.cuba.Level;
import com.kingdee.bos.streamwork.cuba.collection.IMemberList;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.DummyExp;
import com.kingdee.bos.streamwork.cuba.mdx.calc.HierarchyCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.LevelCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Scope;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractMemberListCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.ConstantCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.AllMemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.LevelMembersCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.SetCalc;
import com.kingdee.bos.streamwork.cuba.mdx.func.FuncUtil2;

public class HierarchyMembersCalc
extends AbstractMemberListCalc {
    HierarchyCalc hierarchyCalc;
    Scope.NeedHierarchize needHierarchize = Scope.NeedHierarchize.Yes;
    boolean needNonEmpty = false;

    public HierarchyMembersCalc(Exp exp, HierarchyCalc hierarchyCalc) {
        super(exp, new Calc[]{hierarchyCalc});
        this.hierarchyCalc = hierarchyCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws CUBAException {
        this.needHierarchize = scope.getNeedHierarchize();
        this.needNonEmpty = scope.isNeedNonEmpty();
        Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(null);
        Level[] levels = hierarchy.getLevels();
        if (hierarchy.getDimension().isMeasureDimension() || hierarchy.getDimension().isParentChildrenDimension() || hierarchy.getDimension().isTimeDimension()) {
            return super.optimize(scope, evaluator);
        }
        if (levels.length == 1) {
            LevelCalc levelCalc = ConstantCalc.constantLevel(levels[0]);
            return new LevelMembersCalc((Exp)new DummyExp(this.type), levelCalc).optimize(scope, evaluator);
        }
        if (levels.length == 2 && hierarchy.hasAll()) {
            AllMemberCalc allMemberCalc = new AllMemberCalc(null, this.hierarchyCalc);
            LevelCalc levelCalc = ConstantCalc.constantLevel(levels[1]);
            LevelMembersCalc levelMembersCalc = new LevelMembersCalc(null, levelCalc);
            return new SetCalc(new DummyExp(this.type), new Calc[]{allMemberCalc, levelMembersCalc}).optimize(scope, evaluator);
        }
        return super.optimize(scope, evaluator);
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws CUBAException {
        Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
        IMemberList members = evaluator.getSchemaReader().getHierarchyMembers(hierarchy, this.needHierarchize != Scope.NeedHierarchize.No);
        if (this.needNonEmpty) {
            members = FuncUtil2.nonFactEmptyMembers(evaluator, members);
        }
        return members;
    }
}

