/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Level;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.collection.IMemberList;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.LevelCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.MemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.AbstractMemberCalc;

public class OpeningClosingCalc
extends AbstractMemberCalc {
    MemberCalc memberCalc;
    LevelCalc levelCalc;
    boolean opening;

    public OpeningClosingCalc(Exp call, LevelCalc levelCalc, MemberCalc memberCalc, boolean opening) {
        super(call, new Calc[]{levelCalc, memberCalc});
        this.memberCalc = memberCalc;
        this.levelCalc = levelCalc;
        this.opening = opening;
    }

    @Override
    public Member evaluateMember(Evaluator evaluator) throws CUBAException {
        IMemberList children;
        Level level;
        Member member = this.memberCalc.evaluateMember(evaluator);
        if (this.levelCalc == null) {
            int targetDepth = member.getLevel().getDepth() + 1;
            Level[] levels = member.getHierarchy().getLevels();
            if (levels.length <= targetDepth) {
                return member.getHierarchy().getNullMember();
            }
            level = levels[targetDepth];
        } else {
            level = this.levelCalc.evaluateLevel(evaluator);
        }
        if (level.getDepth() < member.getLevel().getDepth()) {
            return member.getHierarchy().getNullMember();
        }
        if (level == member.getLevel()) {
            return member;
        }
        SchemaReader schemaReader = evaluator.getSchemaReader();
        byte levelDepth = level.getDepth();
        do {
            if ((children = schemaReader.getMemberChildren(member)).size() != 0) continue;
            return level.getHierarchy().getNullMember();
        } while ((member = this.opening ? (Member)children.getFirst() : (Member)children.getLast()).getLevel().getDepth() != levelDepth);
        return member;
    }
}

