/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.elementexp;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.ExpBase;
import com.kingdee.bos.streamwork.cuba.mdx.ExpResolver;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.ConstantCalc;
import com.kingdee.bos.streamwork.cuba.mdx.type.MemberType;
import com.kingdee.bos.streamwork.cuba.mdx.type.Type;

public class MemberExpr
extends ExpBase
implements Exp {
    private final Member member;

    public MemberExpr(Member member) {
        this.member = member;
    }

    public Member getMember() {
        return this.member;
    }

    public String toString() {
        return this.member.getUniqueName();
    }

    @Override
    public Type getType() {
        return MemberType.forMember(this.member);
    }

    @Override
    public Object clone() {
        return new MemberExpr(this.member);
    }

    @Override
    public int getCategory() {
        return 6;
    }

    @Override
    public Calc compile(ExpCompiler compiler) {
        return ConstantCalc.constantMember(this.member);
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws CUBAException {
        return this;
    }

    public Object evaluate(Evaluator evaluator) throws CUBAException {
        return this.member;
    }

    public boolean equals(Object x) {
        if (x instanceof MemberExpr) {
            return this.member.equals(((MemberExpr)x).member);
        }
        return false;
    }
}

