/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.func;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.FunCall;
import com.kingdee.bos.streamwork.cuba.mdx.FunDef;
import com.kingdee.bos.streamwork.cuba.mdx.FunDefBase;
import com.kingdee.bos.streamwork.cuba.mdx.FuncResolver;
import com.kingdee.bos.streamwork.cuba.mdx.FunctionException;
import com.kingdee.bos.streamwork.cuba.mdx.Literal;
import com.kingdee.bos.streamwork.cuba.mdx.MultiFuncResolver;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.bos.streamwork.cuba.mdx.calc.LevelCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.MemberCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.DescendantsCalc;
import com.kingdee.bos.streamwork.cuba.mdx.func.FuncUtil2;
import com.kingdee.bos.streamwork.cuba.util.EnumeratedValues;

class DescendantsFunDef
extends FunDefBase {
    private final boolean self;
    private final boolean before;
    private final boolean after;
    private final boolean depthSpecified;
    private final int depthLimit;

    public DescendantsFunDef(FuncResolver resolver, int returnType, int[] parameterTypes, int flag, boolean depthSpecified, int depthLimit) {
        super(resolver, returnType, parameterTypes);
        this.self = FuncUtil2.checkFlag(flag, 1, true);
        this.after = FuncUtil2.checkFlag(flag, 2, true);
        this.before = FuncUtil2.checkFlag(flag, 4, true);
        this.depthSpecified = depthSpecified;
        this.depthLimit = depthLimit;
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        LevelCalc levelCalc = !this.depthSpecified && call.getArgCount() > 1 ? compiler.compileLevel(call.getArg(1)) : null;
        return new DescendantsCalc(call, memberCalc, levelCalc, this.self, this.before, this.after, this.depthSpecified, this.depthLimit);
    }

    static class Resolver
    extends MultiFuncResolver {
        public Resolver() {
            super("Descendants", "Descendants(<Member>[, <Level>[, <Desc_flag>]])", "Returns the set of descendants of a member at a specified level, optionally including or excluding descendants in other levels.", new String[]{"fxm", "fxml", "fxmly", "fxmn", "fxmny"});
        }

        @Override
        protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws CUBAException {
            Literal literal;
            int depthLimit = -1;
            boolean depthSpecified = false;
            int flag = 1;
            if (args.length == 1) {
                depthLimit = -1;
                flag = 7;
            }
            if (args.length >= 2 && args[1] instanceof Literal && (literal = (Literal)args[1]).getValueObject() instanceof Number) {
                Number number = (Number)literal.getValueObject();
                depthLimit = number.intValue();
                depthSpecified = true;
            }
            if (args.length >= 3) {
                flag = FuncUtil2.getLiteralArg(args, 2, 1, Flags.instance);
            }
            if (FuncUtil2.checkFlag(flag, 8, true)) {
                throw new FunctionException("Descendants Flag 'Leaves' is not supported now");
            }
            int depthLimitFinal = depthLimit < 0 ? Integer.MAX_VALUE : depthLimit;
            int flagFinal = flag;
            boolean depthSpecifiedFinal = depthSpecified;
            return new DescendantsFunDef(this, returnType, parameterTypes, flagFinal, depthSpecifiedFinal, depthLimitFinal);
        }

        @Override
        public String[] getReservedWords() {
            return Flags.instance.getNames();
        }
    }

    static class Flags
    extends EnumeratedValues {
        static final Flags instance = new Flags();
        public static final int SELF = 1;
        public static final int AFTER = 2;
        public static final int BEFORE = 4;
        public static final int BEFORE_AND_AFTER = 6;
        public static final int SELF_AND_AFTER = 3;
        public static final int SELF_AND_BEFORE = 5;
        public static final int SELF_BEFORE_AFTER = 7;
        public static final int LEAVES = 8;

        private Flags() {
            super(new String[]{"SELF", "AFTER", "BEFORE", "BEFORE_AND_AFTER", "SELF_AND_AFTER", "SELF_AND_BEFORE", "SELF_BEFORE_AFTER", "LEAVES"}, new int[]{1, 2, 4, 6, 3, 5, 7, 8});
        }
    }
}

