/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.mdx.func;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.FunCall;
import com.kingdee.bos.streamwork.cuba.mdx.FunDef;
import com.kingdee.bos.streamwork.cuba.mdx.FunDefBase;
import com.kingdee.bos.streamwork.cuba.mdx.FuncResolver;
import com.kingdee.bos.streamwork.cuba.mdx.MultiFuncResolver;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ExpCompiler;
import com.kingdee.bos.streamwork.cuba.mdx.calc.ListCalc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.impl.func.OrderCalc;
import com.kingdee.bos.streamwork.cuba.mdx.func.FuncUtil2;
import com.kingdee.bos.streamwork.cuba.util.EnumeratedValues;

class OrderFunDef
extends FunDefBase {
    public OrderFunDef(FuncResolver resolver, int returnType, int[] parameterTypes, boolean desc, boolean brk) {
        super(resolver, returnType, parameterTypes);
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws CUBAException {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        Calc expCalc = compiler.compileScalar(call.getArg(1), true);
        int order = FuncUtil2.getLiteralArg(call.getArgs(), 2, 0, Flags.instance);
        boolean desc = Flags.isDescending(order);
        boolean brk = Flags.isBreak(order);
        return new OrderCalc(call, listCalc, expCalc, desc, brk);
    }

    static class Flags
    extends EnumeratedValues {
        static final Flags instance = new Flags();
        public static final int ASC = 0;
        public static final int DESC = 1;
        public static final int BASC = 2;
        public static final int BDESC = 3;

        private Flags() {
            super(new String[]{"ASC", "DESC", "BASC", "BDESC"});
        }

        public static final boolean isDescending(int value) {
            return (value & 1) == 1;
        }

        public static final boolean isBreak(int value) {
            return (value & 2) == 2;
        }
    }

    static class OrderFuncResolver
    extends MultiFuncResolver {
        public OrderFuncResolver() {
            super("Order", "Order(<Set>, <Value Expression>[, ASC | DESC | BASC | BDESC])", "Arranges members of a set, optionally preserving or breaking the hierarchy.", new String[]{"fxxvy", "fxxv"});
        }

        @Override
        public String[] getReservedWords() {
            return Flags.instance.getNames();
        }

        @Override
        protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws CUBAException {
            int order = FuncUtil2.getLiteralArg(args, 2, 0, Flags.instance);
            boolean desc = Flags.isDescending(order);
            boolean brk = Flags.isBreak(order);
            return new OrderFunDef(this, returnType, parameterTypes, desc, brk);
        }
    }
}

