/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.q;

import com.kingdee.bos.streamwork.cuba.Cell;
import com.kingdee.bos.streamwork.cuba.Position;
import com.kingdee.bos.streamwork.cuba.impl.PositionIterable;
import com.kingdee.bos.streamwork.cuba.q.Edge;
import com.kingdee.bos.streamwork.cuba.q.EdgeImpl;
import com.kingdee.bos.streamwork.cuba.q.Result;
import com.kingdee.bos.streamwork.cuba.q.ResultImpl;
import java.util.BitSet;
import java.util.Iterator;

public class NonEmptyResult
implements Result {
    private ResultImpl result;
    private boolean rowsNonEmpty;
    private boolean columnsNonEmpty;
    private Edge rowsEdge = null;
    private Edge columnsEdge = null;
    private int[] rowsOffset;
    private int[] columnsOffset;

    public NonEmptyResult(ResultImpl result, boolean rowsNonEmpty, boolean columnsNonEmpty) {
        this.result = result;
        this.rowsNonEmpty = rowsNonEmpty;
        this.columnsNonEmpty = columnsNonEmpty;
        this.build(result);
    }

    private void build(ResultImpl result) {
        if (this.rowsNonEmpty) {
            this.rowsOffset = this.buildOffset(result.getRowBitSet());
            this.rowsEdge = this.buildEdge(result.getEdge("rows"), result.getRowBitSet(), this.rowsOffset);
        } else {
            this.rowsEdge = result.getEdge("rows");
        }
        if (this.columnsNonEmpty) {
            this.columnsOffset = this.buildOffset(result.getColumnBitSet());
            this.columnsEdge = this.buildEdge(result.getEdge("columns"), result.getColumnBitSet(), this.columnsOffset);
        } else {
            this.columnsEdge = result.getEdge("columns");
        }
    }

    private int[] buildOffset(BitSet bitSet) {
        int length = bitSet.cardinality();
        int[] offsets = new int[length];
        int index = 0;
        for (int pos = 0; pos < bitSet.length(); ++pos) {
            if (!bitSet.get(pos)) continue;
            offsets[index++] = pos;
        }
        return offsets;
    }

    private Edge buildEdge(final Edge edge, BitSet rowBitSet, final int[] offset) {
        final int offsetCount = offset.length;
        PositionIterable iterable = new PositionIterable(){

            @Override
            public Iterator<Position> iterator() {
                final Iterator<Position> iter = edge.getPositionIterator();
                return new Iterator<Position>(){
                    int index = 0;
                    int pos = 0;

                    @Override
                    public boolean hasNext() {
                        if (this.pos < offsetCount) {
                            while (this.index < offset[this.pos]) {
                                iter.next();
                                ++this.index;
                            }
                            return this.index == offset[this.pos];
                        }
                        return false;
                    }

                    @Override
                    public Position next() {
                        Position position = (Position)iter.next();
                        ++this.index;
                        ++this.pos;
                        return position;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        return new EdgeImpl(edge.getName(), edge.getHierarchies(), iterable, rowBitSet.cardinality());
    }

    @Override
    public Cell getCell(int row, int column) {
        if (this.rowsNonEmpty) {
            row = this.rowsOffset[row];
        }
        if (this.columnsNonEmpty) {
            column = this.columnsOffset[column];
        }
        return this.result.getCell(row, column);
    }

    @Override
    public Edge getEdge(int index) {
        return 0 == index ? this.rowsEdge : this.columnsEdge;
    }

    @Override
    public Edge getEdge(String name) {
        return "rows".equalsIgnoreCase(name) ? this.rowsEdge : this.columnsEdge;
    }
}

