/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.q;

import com.kingdee.bos.streamwork.cuba.q.Bitmap;
import com.kingdee.bos.streamwork.cuba.q.BitmapImpl;
import java.util.HashMap;

public class PagedValue<T> {
    Bitmap bitmap;
    HashMap<Integer, T> values = new HashMap();
    private int top;
    private int left;
    private int rowCount;
    private int columnCount;

    public PagedValue(int top, int left, int rowCount, int columnCount) {
        this.top = top;
        this.left = left;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.bitmap = new BitmapImpl(top, left, rowCount, columnCount);
    }

    public void setValue(int row, int column, T value) {
        this.bitmap.set(row, column);
        int key = this.calcKey(row, column);
        this.values.put(key, value);
    }

    public T getValue(int row, int column) {
        if (this.bitmap.get(row, column)) {
            return this.values.get(this.calcKey(row, column));
        }
        return null;
    }

    private int calcKey(int row, int column) {
        return row * this.columnCount + column;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int valueCount() {
        return this.values.size();
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }
}

