/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.q;

import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.Cell;
import com.kingdee.bos.streamwork.cuba.Formatter;
import com.kingdee.bos.streamwork.cuba.Hierarchy;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.Position;
import com.kingdee.bos.streamwork.cuba.collection.IList;
import com.kingdee.bos.streamwork.cuba.impl.CellImpl;
import com.kingdee.bos.streamwork.cuba.impl.ConnectionImpl;
import com.kingdee.bos.streamwork.cuba.impl.CubeImpl;
import com.kingdee.bos.streamwork.cuba.impl.EvaluatorImpl;
import com.kingdee.bos.streamwork.cuba.impl.PositionImpl;
import com.kingdee.bos.streamwork.cuba.impl.PositionIterable;
import com.kingdee.bos.streamwork.cuba.mdx.CellReader;
import com.kingdee.bos.streamwork.cuba.mdx.Evaluator;
import com.kingdee.bos.streamwork.cuba.mdx.MdxQuery;
import com.kingdee.bos.streamwork.cuba.mdx.QueryAxis;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.bos.streamwork.cuba.mdx.calc.Scope;
import com.kingdee.bos.streamwork.cuba.q.EdgeImpl;
import com.kingdee.bos.streamwork.cuba.q.NonEmptyResult;
import com.kingdee.bos.streamwork.cuba.q.Result;
import com.kingdee.bos.streamwork.cuba.q.ResultImpl;
import com.kingdee.bos.streamwork.cuba.util.Util;
import com.kingdee.util.LRUMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ResultBuilder {
    private MdxQuery query;
    private QueryAxis rowsAxis;
    private QueryAxis columnsAxis;
    CubeImpl cube;
    ConnectionImpl cn;
    CellReader cellReader;
    EvaluatorImpl evaluator;
    private int pageRowNum;
    private int pageColumnNum;
    private Member[] sliceMembers;
    private int rowsCount;
    private int columnsCount;

    public ResultBuilder(MdxQuery query) throws CUBAException {
        this.query = query;
        this.cube = (CubeImpl)query.getCube();
        this.cn = (ConnectionImpl)query.getConnection();
        this.cellReader = this.cn.getCellReader(this.cube);
        this.evaluator = new EvaluatorImpl(this.cn, query, this.cube, this.cellReader);
        LRUMap pinCache = new LRUMap();
        pinCache.setMaxSize(1000);
        this.evaluator.setPinCache(new HashMap());
        this.rowsAxis = query.getAxis("rows");
        this.columnsAxis = query.getAxis("columns");
    }

    public Result build() throws CUBAException {
        Scope scope;
        long t1 = System.currentTimeMillis();
        Calc slicerCalc = this.query.getSlicerCalc();
        if (slicerCalc != null) {
            Scope scope2 = new Scope(slicerCalc, false, Scope.NeedHierarchize.No);
            slicerCalc = slicerCalc.optimize(scope2, this.evaluator);
            this.sliceMembers = this.executeSliceAxis(this.evaluator.push(), slicerCalc);
            this.evaluator.setContext(this.sliceMembers);
            this.evaluator.setSlicerMember(this.sliceMembers);
        }
        Calc rowsCalc = this.query.getAxisCalc("rows");
        Calc columnsCalc = this.query.getAxisCalc("columns");
        IList rowsPositionList = null;
        IList columnsPositionList = null;
        if (rowsCalc != null) {
            scope = new Scope(rowsCalc, this.rowsAxis.isNonEmpty(), Scope.NeedHierarchize.Unknow);
            rowsCalc = rowsCalc.optimize(scope, this.evaluator);
            rowsPositionList = this.executeAxis(this.cellReader, this.evaluator, this.rowsAxis, rowsCalc);
        }
        if (columnsCalc != null) {
            scope = new Scope(columnsCalc, this.columnsAxis.isNonEmpty(), Scope.NeedHierarchize.Unknow);
            columnsCalc = columnsCalc.optimize(scope, this.evaluator);
            columnsPositionList = this.executeAxis(this.cellReader, this.evaluator, this.columnsAxis, columnsCalc);
        }
        this.calcPageNum(rowsPositionList, columnsPositionList);
        Result ret = null;
        ResultImpl result = null;
        PositionIterable rowsPositionIterable = this.toPositionIterable(rowsPositionList);
        PositionIterable columnsPositionIterable = this.toPositionIterable(columnsPositionList);
        if (rowsPositionIterable != null && columnsPositionIterable != null) {
            result = new ResultImpl(this.pageRowNum, this.pageColumnNum, rowsPositionList.size(), columnsPositionList.size());
            this.executeBodyBoth(this.evaluator, result, rowsPositionIterable, columnsPositionIterable);
            result.setRowsEdge(new EdgeImpl("rows", this.query.collectHierarchies(this.rowsAxis.getExp()), rowsPositionIterable, rowsPositionList.size()));
            result.setColumnsEdge(new EdgeImpl("columns", this.query.collectHierarchies(this.columnsAxis.getExp()), columnsPositionIterable, columnsPositionList.size()));
        } else if (rowsPositionIterable != null) {
            this.executeBodyOne(this.evaluator, result, rowsPositionIterable);
        } else {
            this.executeBodyOne(this.evaluator, result, columnsPositionIterable);
        }
        System.out.println("rows: " + result.getEdge("rows").getPositionCount());
        System.out.println("columns: " + result.getEdge("columns").getPositionCount());
        System.out.println("Not empty rows: " + result.getRowBitSet().cardinality());
        System.out.println("Not empty columns: " + result.getColumnBitSet().cardinality());
        System.out.println("Not empty cells:" + result.getNotEmptyCellCount());
        if (this.evaluator.getPinCache() != null) {
            System.out.println("pinCache size: " + this.evaluator.getPinCache().size());
        }
        boolean rowsNonEmpty = this.rowsAxis.isNonEmpty() && result.getRowCount() != result.getNonEmptyRowCount();
        boolean columnsNonEmpty = this.columnsAxis.isNonEmpty() && result.getColumnCount() != result.getNonEmptyColumnCount();
        ret = rowsNonEmpty || columnsNonEmpty ? new NonEmptyResult(result, rowsNonEmpty, columnsNonEmpty) : result;
        System.out.println("ResultBuilder.build:" + (System.currentTimeMillis() - t1) + " ms.");
        if (this.evaluator.getPinCache() != null) {
            this.evaluator.getPinCache().clear();
            this.evaluator.setPinCache(null);
        }
        return ret;
    }

    private void executeBodyOne(EvaluatorImpl evaluator, ResultImpl result, PositionIterable positionIterable) {
    }

    private void executeBodyBoth(EvaluatorImpl evaluator, ResultImpl result, PositionIterable rowsPositionIterable, PositionIterable columnsPositionIterable) throws CUBAException {
        long t1 = System.currentTimeMillis();
        int rowIndex = 0;
        int columnIndex = 0;
        Iterator rowsPositionIterator = rowsPositionIterable.iterator();
        while (rowsPositionIterator.hasNext()) {
            columnIndex = 0;
            Position position = (Position)rowsPositionIterator.next();
            Member[] rowTuple = position.getMembers();
            evaluator.setContext(rowTuple);
            Iterator columnsPositionIterator = columnsPositionIterable.iterator();
            while (columnsPositionIterator.hasNext()) {
                Member[] columnTuple = ((Position)columnsPositionIterator.next()).getMembers();
                evaluator.setContext(columnTuple);
                Cell cell = this.executeCell(evaluator);
                result.getCellWritable(rowIndex, columnIndex).setCell(rowIndex, columnIndex, cell);
                ++columnIndex;
            }
            ++rowIndex;
        }
        System.out.println("ResultBuilder.executeBodyBoth:" + (System.currentTimeMillis() - t1) + " ms.");
    }

    private Cell executeCell(EvaluatorImpl evaluator) throws CUBAException {
        Member[] context = null;
        Object o = null;
        try {
            context = (Member[])evaluator.getCurrentMembers().clone();
            o = evaluator.evaluateCurrent();
        }
        catch (Exception e) {
            o = e;
        }
        if (o != null && o != Util.nullValue && !(o instanceof Exception)) {
            String fmtStr = null;
            Member solveMember = evaluator.getMaxSolveMember();
            if (solveMember != null) {
                fmtStr = (String)solveMember.getProperty("formatString");
            }
            if (fmtStr == null) {
                Member measure = evaluator.getContext(evaluator.getCube().getMeasureDimension());
                fmtStr = (String)measure.getProperty("formatString");
            }
            return new CellImpl(context, o, new Formatter(fmtStr));
        }
        return null;
    }

    private PositionIterable toPositionIterable(final IList positionList) {
        if (positionList == null) {
            return null;
        }
        return new PositionIterable(){

            @Override
            public Iterator<Position> iterator() {
                final Iterator iter = positionList.iterator();
                return new Iterator<Position>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public Position next() {
                        Object v = iter.next();
                        if (v instanceof Position) {
                            return (Position)v;
                        }
                        if (v instanceof Member[]) {
                            return new PositionImpl((Member[])v);
                        }
                        if (v instanceof Member) {
                            return new PositionImpl(new Member[]{(Member)v});
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private void calcPageNum(IList rowsPositionList, IList columnsPositionList) {
        if (rowsPositionList != null) {
            this.rowsCount = rowsPositionList.size();
        }
        if (columnsPositionList != null) {
            this.columnsCount = columnsPositionList.size();
        }
        this.pageRowNum = this.rowsCount > 320 ? 320 : this.rowsCount;
        this.pageColumnNum = this.columnsCount > 64 ? 64 : this.columnsCount;
    }

    private IList executeAxis(CellReader cellReader, Evaluator evaluator, QueryAxis axis, Calc calc) throws CUBAException {
        boolean nonEmpty = axis.isNonEmpty();
        evaluator.setNonEmpty(nonEmpty);
        boolean nonFactEmpty = axis.isNonFactEmpty();
        evaluator.setNonFactEmpty(nonFactEmpty);
        Object value = calc.evaluate(evaluator);
        evaluator.setNonEmpty(false);
        evaluator.setNonFactEmpty(false);
        if (value == null) {
            value = Collections.EMPTY_LIST;
        }
        IList list = (IList)value;
        return list;
    }

    private Member[] executeSliceAxis(Evaluator evaluator, Calc calc) throws CUBAException {
        IList list;
        Object value = calc.evaluate(evaluator);
        if (value instanceof Member || value instanceof Member[]) {
            list = this.query.getListFactory().createArrayList();
            list.add(value);
            value = list;
        }
        list = (IList)value;
        Object o = list.getFirst();
        IList members = this.query.getListFactory().createArrayList();
        if (o != null) {
            if (o instanceof Object[]) {
                Object[] a = (Object[])o;
                HashMap<Hierarchy, IList> map = new HashMap<Hierarchy, IList>(3);
                for (int j = 0; j < a.length; ++j) {
                    if (a[j] == null) continue;
                    Member tm = (Member)a[j];
                    members.add(tm);
                    o = map.get(tm.getHierarchy());
                    if (o != null) {
                        ((IList)o).add(tm);
                        continue;
                    }
                    IList l = this.query.getListFactory().createArrayList();
                    l.add(tm);
                    map.put(tm.getHierarchy(), l);
                }
                if (map.size() != members.size()) {
                    for (Map.Entry entry : map.entrySet()) {
                        Hierarchy hier = (Hierarchy)entry.getKey();
                        IList memberList = (IList)entry.getValue();
                        if (memberList.size() == 1) {
                            members.add(memberList.get(0));
                            continue;
                        }
                        members.add(evaluator.getQuery().addSlicerCompoundMember(hier, (Member[])memberList.toArray(new Member[0])));
                    }
                }
            } else {
                members.add(o);
            }
        }
        return (Member[])members.toArray(new Member[0]);
    }
}

