/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.cuba.q;

import com.kingdee.bos.streamwork.cuba.Cell;
import com.kingdee.bos.streamwork.cuba.q.Bitmap;
import com.kingdee.bos.streamwork.cuba.q.CellSet;
import com.kingdee.bos.streamwork.cuba.q.CellSetHolder;
import com.kingdee.bos.streamwork.cuba.q.CellSetHolderFactory;
import com.kingdee.bos.streamwork.cuba.q.CellWritable;
import com.kingdee.bos.streamwork.cuba.q.Edge;
import com.kingdee.bos.streamwork.cuba.q.Result;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;

public class ResultImpl
implements Result {
    private int pageRowNum;
    private int pageColumnNum;
    private int rowCount;
    private int columnCount;
    private int rowPageCount;
    private int columnPageCount;
    private Edge rowsEdge;
    private Edge columnsEdge;
    private HashMap<Integer, CellSetHolder> holderMap = new HashMap();
    private ArrayList<CellSetHolder> holderList = new ArrayList();
    private BitSet rowBitSet;
    private BitSet columnBitSet;

    public ResultImpl(int pageRowNum, int pageColumnNum, int rowCount, int columnCount) {
        this.pageRowNum = pageRowNum;
        this.pageColumnNum = pageColumnNum;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.rowPageCount = (rowCount - 1) / pageRowNum + 1;
        this.columnPageCount = (columnCount - 1) / pageColumnNum + 1;
    }

    public CellSet getCellSetAt(int row, int column) {
        int pageNo = this.pageNo(row, column);
        CellSetHolder holder = this.holderMap.get(pageNo);
        if (holder != null) {
            return holder.getCellSet();
        }
        return null;
    }

    @Override
    public Cell getCell(int row, int column) {
        CellSet cellSet = this.getCellSetAt(row, column);
        if (cellSet != null) {
            return cellSet.getCell(row, column);
        }
        return null;
    }

    public CellWritable getCellWritable(int row, int column) {
        int pageNo = this.pageNo(row, column);
        CellWritable writable = null;
        CellSetHolder holder = this.holderMap.get(pageNo);
        if (holder == null) {
            holder = CellSetHolderFactory.createCellSetHolder();
            this.holderMap.put(pageNo, holder);
        } else {
            writable = holder.getCellWritable();
        }
        if (writable == null) {
            int pageColumnCount;
            int top = row / this.pageRowNum * this.pageRowNum;
            int left = column / this.pageColumnNum * this.pageColumnNum;
            int pageRowCount = this.pageRowNum;
            if (top + pageRowCount > this.rowCount) {
                pageRowCount = this.rowCount - top;
            }
            if (left + (pageColumnCount = this.pageColumnNum) > this.columnCount) {
                pageColumnCount = this.columnCount - left;
            }
            writable = holder.build(top, left, pageRowCount, pageColumnCount);
        }
        return writable;
    }

    private int pageNo(int row, int column) {
        int rowPageIndex = row / this.pageRowNum;
        int columnPageIndex = column / this.pageColumnNum;
        int pageNo = rowPageIndex * this.columnPageCount + columnPageIndex;
        return pageNo;
    }

    @Override
    public Edge getEdge(int index) {
        return 0 == index ? this.rowsEdge : this.columnsEdge;
    }

    @Override
    public Edge getEdge(String name) {
        return "rows".equalsIgnoreCase(name) ? this.rowsEdge : this.columnsEdge;
    }

    public void setRowsEdge(Edge edge) {
        this.rowsEdge = edge;
    }

    public void setColumnsEdge(Edge edge) {
        this.columnsEdge = edge;
    }

    public BitSet getRowBitSet() {
        if (this.rowBitSet != null) {
            return this.rowBitSet;
        }
        ArrayList<BitSet> bitsets = new ArrayList<BitSet>();
        for (int i = 0; i < this.rowPageCount; ++i) {
            int pageNo = i * this.columnPageCount;
            Bitmap bm = this.holderMap.get(pageNo).getCellSet().getBitmap();
            BitSet bitSet = bm.xOr();
            for (int j = 1; j < this.columnPageCount; ++j) {
                bm = this.holderMap.get(++pageNo).getCellSet().getBitmap();
                bitSet.or(bm.xOr());
            }
            bitsets.add(bitSet);
        }
        if (bitsets.size() == 1) {
            this.rowBitSet = (BitSet)bitsets.get(0);
        } else {
            BitSet bitSet = (BitSet)bitsets.get(0);
            for (int i = 1; i < this.rowPageCount; ++i) {
                int start = i * this.pageRowNum;
                BitSet bitSet2 = (BitSet)bitsets.get(i);
                if (bitSet2.cardinality() <= 0) continue;
                int count = i == this.rowPageCount - 1 ? this.rowCount % this.pageRowNum : this.pageRowNum;
                for (int j = 0; j < count; ++j) {
                    if (!bitSet2.get(j)) continue;
                    bitSet.set(start + j);
                }
            }
            this.rowBitSet = bitSet;
        }
        return this.rowBitSet;
    }

    public BitSet getColumnBitSet() {
        if (this.columnBitSet != null) {
            return this.columnBitSet;
        }
        ArrayList<BitSet> bitsets = new ArrayList<BitSet>();
        for (int i = 0; i < this.columnPageCount; ++i) {
            int pageNo = i;
            Bitmap bm = this.holderMap.get(pageNo).getCellSet().getBitmap();
            BitSet bitSet = bm.yOr();
            for (int j = 1; j < this.rowPageCount; ++j) {
                bm = this.holderMap.get(pageNo += this.columnPageCount).getCellSet().getBitmap();
                bitSet.or(bm.yOr());
            }
            bitsets.add(bitSet);
        }
        if (bitsets.size() == 1) {
            this.columnBitSet = (BitSet)bitsets.get(0);
        } else {
            BitSet bitSet = (BitSet)bitsets.get(0);
            for (int i = 1; i < this.columnPageCount; ++i) {
                int start = i * this.pageColumnNum;
                BitSet bitSet2 = (BitSet)bitsets.get(i);
                if (bitSet2.cardinality() <= 0) continue;
                int count = i == this.columnPageCount - 1 ? this.columnCount % this.pageColumnNum : this.pageColumnNum;
                for (int j = 0; j < count; ++j) {
                    if (!bitSet2.get(j)) continue;
                    bitSet.set(start + j);
                }
            }
            this.columnBitSet = bitSet;
        }
        return this.columnBitSet;
    }

    public int getNotEmptyCellCount() {
        int count = 0;
        Iterator<CellSetHolder> iter = this.holderMap.values().iterator();
        while (iter.hasNext()) {
            count += iter.next().getCellSet().getNotEmptyCellCount();
        }
        return count;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getNonEmptyRowCount() {
        return this.getRowBitSet().cardinality();
    }

    public int getNonEmptyColumnCount() {
        return this.getColumnBitSet().cardinality();
    }
}

