/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.datasource;

import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.streamwork.columnbased.BitmapVector;
import com.kingdee.bos.streamwork.columnbased.CBTable;
import com.kingdee.bos.streamwork.columnbased.SimpleCBTable;
import com.kingdee.bos.streamwork.columnbased.TableBuilder;
import com.kingdee.bos.streamwork.columnbased.Vector;
import com.kingdee.bos.streamwork.columnbased.VectorConverter;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCachedPage;
import com.kingdee.bos.streamwork.pivot.PivotException;
import com.kingdee.bos.streamwork.service.StreamWorkService;
import com.kingdee.bos.streamwork.xls.IXlsReader;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnBasedDataSource
extends DataSourceWithCachedPage
implements DataSource,
Serializable {
    CBTable cbTable;

    @Override
    public int[] getColumnTypes() {
        return this.cbTable.getColumnTypes();
    }

    @Override
    public String[] getColumnNames() {
        return this.cbTable.getColumnNames();
    }

    @Override
    public int getRowCount() {
        return this.cbTable.getRowCount();
    }

    @Override
    public Object getCell(int columnIndex, int rowIndex) {
        return this.cbTable.getCell(columnIndex, rowIndex);
    }

    public ColumnBasedDataSource(ResultSet rs) {
        this.build(rs, Integer.MAX_VALUE, null);
    }

    public ColumnBasedDataSource(ResultSet rs, String[] columnNames) {
        this.build(rs, Integer.MAX_VALUE, columnNames);
    }

    public ColumnBasedDataSource(ResultSet rs, int limit) {
        this.build(rs, limit, null);
    }

    public ColumnBasedDataSource(ResultSet rs, int limit, String[] columnNames) {
        this.build(rs, limit, columnNames);
    }

    public ColumnBasedDataSource(IXlsReader rs) {
        this.build(rs, Integer.MAX_VALUE, null);
    }

    public ColumnBasedDataSource(IXlsReader rs, String[] columnNames) {
        this.build(rs, Integer.MAX_VALUE, columnNames);
    }

    public ColumnBasedDataSource(IXlsReader rs, int limit) {
        this.build(rs, limit, null);
    }

    public ColumnBasedDataSource(IXlsReader rs, int limit, String[] columnNames) {
        this.build(rs, limit, columnNames);
    }

    public ColumnBasedDataSource(ResultSet rs, int limit, String[] columnNames, List<PropertyUnitDele> properties, Map aliasMap) {
        this.build(rs, limit, columnNames, properties, aliasMap);
    }

    private int getIndex(ResultSetMetaData rsmd, String columnName) throws SQLException {
        int n = rsmd.getColumnCount() + 1;
        for (int i = 1; i < n; ++i) {
            if (!columnName.equalsIgnoreCase(rsmd.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    private PropertyUnitDele getDele(List<PropertyUnitDele> properties, String name) {
        for (PropertyUnitDele dele : properties) {
            if (!dele.getName().equalsIgnoreCase(name)) continue;
            return dele;
        }
        return null;
    }

    private void build(IXlsReader reader, int limit, String[] columnNames) {
        try {
            int i;
            if (columnNames == null) {
                columnNames = reader.getColumnNames();
            }
            int columnCount = columnNames.length;
            int[] columnIndexes = new int[columnCount];
            int[] columnTypes = new int[columnCount];
            Vector[] vectors = new Vector[columnCount];
            for (int i2 = 0; i2 < columnCount; ++i2) {
                columnIndexes[i2] = i2 + 1;
                vectors[i2] = new BitmapVector();
            }
            HashMap<Object, Object> valueMap = new HashMap<Object, Object>();
            int index = 0;
            while (index++ < limit && reader.next()) {
                for (i = 0; i < columnCount; ++i) {
                    Object v = reader.getObject(i + 1);
                    if (v != null && (v = this.transferValue(v)) != null) {
                        Object v2 = valueMap.get(v);
                        if (v2 == null) {
                            valueMap.put(v, v);
                        } else {
                            v = v2;
                        }
                    }
                    vectors[i].append(v);
                    vectors[i] = VectorConverter.convert(vectors[i]);
                }
            }
            for (i = 0; i < columnCount; ++i) {
                vectors[i] = VectorConverter.convert(vectors[i]);
                vectors[i].markFinish();
            }
            this.cbTable = new SimpleCBTable(columnNames, columnTypes, vectors);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PivotException(e);
        }
    }

    private void build(ResultSet rs, int limit, String[] columnNames) {
        try {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int[] columnIndexes = new int[columnCount];
            int[] columnTypes = new int[columnCount];
            Vector[] vectors = new Vector[columnCount];
            String[] columnNames2 = columnNames == null ? new String[columnCount] : columnNames;
            for (int i2 = 0; i2 < columnCount; ++i2) {
                columnIndexes[i2] = i2 + 1;
                if (columnNames == null) {
                    columnNames2[i2] = rsmd.getColumnName(i2 + 1);
                }
                columnTypes[i2] = rsmd.getColumnType(i2 + 1);
                vectors[i2] = TableBuilder.createDefaultVector(columnTypes[i2]);
            }
            HashMap<Object, Object> valueMap = new HashMap<Object, Object>();
            int index = 0;
            while (index++ < limit && rs.next()) {
                for (i = 0; i < columnCount; ++i) {
                    Object v = null;
                    int type = columnTypes[i];
                    switch (type) {
                        case 91: 
                        case 92: 
                        case 93: {
                            v = rs.getDate(i + 1);
                            break;
                        }
                        case 4: {
                            v = rs.getInt(i + 1);
                            break;
                        }
                        default: {
                            v = rs.getObject(i + 1);
                        }
                    }
                    if (v != null && (v = this.transferValue(v)) != null) {
                        Object v2 = valueMap.get(v);
                        if (v2 == null) {
                            valueMap.put(v, v);
                        } else {
                            v = v2;
                        }
                    }
                    vectors[i].append(v);
                    vectors[i] = VectorConverter.convert(vectors[i]);
                }
            }
            for (i = 0; i < columnCount; ++i) {
                vectors[i] = VectorConverter.convert(vectors[i]);
                vectors[i].markFinish();
            }
            this.cbTable = new SimpleCBTable(columnNames2, columnTypes, vectors);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PivotException(e);
        }
    }

    private void build(ResultSet rs, int limit, String[] columnNames, List<PropertyUnitDele> properties, Map aliasMap) {
        int columnCount = columnNames.length;
        int[] columnTypes = new int[columnCount];
        int[] columnIndexes = new int[columnCount];
        Vector[] vectors = new Vector[columnCount];
        PropertyUnitDele[] deles = new PropertyUnitDele[columnCount];
        try {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i2 = 0; i2 < columnCount; ++i2) {
                int index = this.getIndex(rsmd, columnNames[i2]);
                if (index == -1 && aliasMap != null && aliasMap.get(columnNames[i2]) != null) {
                    index = this.getIndex(rsmd, aliasMap.get(columnNames[i2]).toString());
                }
                if (index >= 0) {
                    columnIndexes[i2] = index;
                    columnTypes[i2] = rsmd.getColumnType(index);
                    deles[i2] = this.getDele(properties, columnNames[i2]);
                    vectors[i2] = TableBuilder.createDefaultVector(columnTypes[i2]);
                    continue;
                }
                vectors[i2] = TableBuilder.createDefaultVector(12);
            }
            HashMap<Object, Object> valueMap = new HashMap<Object, Object>();
            HashMap cache = new HashMap();
            HashMap enumPkCache = new HashMap();
            int index = 0;
            while (index++ < limit && rs.next()) {
                for (i = 0; i < columnCount; ++i) {
                    Object v = null;
                    if (columnIndexes[i] > 0) {
                        v = StreamWorkService.getObject(rs, columnIndexes[i], deles[i], cache, enumPkCache);
                    }
                    if (v != null && (v = this.transferValue(v)) != null) {
                        Object v2 = valueMap.get(v);
                        if (v2 == null) {
                            valueMap.put(v, v);
                        } else {
                            v = v2;
                        }
                    }
                    vectors[i].append(v);
                    vectors[i] = VectorConverter.convert(vectors[i]);
                }
            }
            for (i = 0; i < columnCount; ++i) {
                vectors[i] = VectorConverter.convert(vectors[i]);
                vectors[i].markFinish();
            }
            this.cbTable = new SimpleCBTable(columnNames, columnTypes, vectors);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PivotException(e);
        }
    }
}

