/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.metric;

import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.metric.MetricSpec;
import com.kingdee.bos.streamwork.metric.MetricType;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import java.io.Serializable;

public class AvgMetric
extends Metric
implements Serializable {
    public AvgMetric(String name, String caption, MetricSpec spec) {
        super(name, caption, spec);
    }

    @Override
    public MetricType getType() {
        return MetricType.AVG;
    }

    @Override
    public String getFormatString(int defaultScale) {
        String precision = this.spec.get("precision");
        if (precision != null) {
            defaultScale = Integer.parseInt(precision);
        }
        String fAmount = "#,###";
        if (defaultScale > 0) {
            fAmount = fAmount + ".";
            for (int i = 0; i < defaultScale; ++i) {
                fAmount = fAmount + "0";
            }
        }
        return fAmount;
    }

    @Override
    public String getFormular(QueryModel queryModel) {
        String left = this.spec.get("left");
        String right = this.spec.get("right");
        left = this.checkMeasure(queryModel, left);
        right = this.checkMeasure(queryModel, right);
        if (left == null || right == null) {
            return "0";
        }
        return "1.0 * Measures.[" + left + "]/Measures.[" + right + "]";
    }

    private String checkMeasure(QueryModel queryModel, String name) {
        for (Measure measure : queryModel.measures) {
            if (!measure.getId().equals(name)) continue;
            return name;
        }
        if (queryModel.metrics != null) {
            for (Metric metric : queryModel.metrics) {
                if (!metric.name.equals(name)) continue;
                return name;
            }
        }
        String another = null;
        for (Measure measure : queryModel.measures) {
            if (!measure.name.equals(name)) continue;
            if (another == null) {
                another = measure.getId();
                continue;
            }
            return null;
        }
        return another;
    }

    @Override
    public String[] getReference() {
        String left = this.spec.get("left");
        String right = this.spec.get("right");
        return new String[]{left, right};
    }
}

