/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.metric;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.streamwork.metric.AvgMetric;
import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.metric.MetricSpec;
import com.kingdee.bos.streamwork.metric.MetricUI;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.model.DataModel2;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;

public class AvgMetricUI
extends MetricUI {
    private KDLabel lblNote;
    private KDComboBox cbLeft;
    private KDComboBox cbRight;

    @Override
    public boolean verify(Window parent) {
        if (!(this.cbLeft.getSelectedItem() instanceof Measure) || !(this.cbRight.getSelectedItem() instanceof Measure)) {
            PivotUtils.alert("\u8bf7\u9009\u62e9\u7edf\u8ba1\u5b57\u6bb5", parent);
            return false;
        }
        return true;
    }

    @Override
    public Metric getMetric(String name, String caption) {
        Measure leftMeasure = (Measure)this.cbLeft.getSelectedItem();
        Measure rightMeasure = (Measure)this.cbRight.getSelectedItem();
        MetricSpec spec = new MetricSpec();
        spec.put("left", leftMeasure.getId());
        spec.put("right", rightMeasure.getId());
        return new AvgMetric(name, caption, spec);
    }

    @Override
    public void initUI() {
        this.cbLeft = new KDComboBox();
        this.cbLeft.setPreferredSize(new Dimension(250, 25));
        this.cbRight = new KDComboBox();
        this.cbRight.setPreferredSize(new Dimension(250, 25));
        this.lblNote = new KDLabel();
        this.lblNote.setText("\u6c47\u603b\u5e73\u5747\u503c\uff0c\u683c\u5f0f\uff1a [\u7edf\u8ba1\u5b57\u6bb5]/[\u7edf\u8ba1\u5b57\u6bb5], \u8bf7\u9009\u62e9\u5206\u5b50\u5206\u6bcd\u5b57\u6bb5\uff1a");
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblNote, "North");
        KDPanel flowPanel = new KDPanel();
        flowPanel.setLayout((LayoutManager)new FlowLayout());
        flowPanel.add((Component)this.cbLeft);
        flowPanel.add((Component)new KDLabel("/"));
        flowPanel.add((Component)this.cbRight);
        this.add((Component)flowPanel, "Center");
    }

    private void loadData(Measure[] measures, KDComboBox cb) {
        Object o = cb.getSelectedItem();
        Measure oldMeasure = null;
        if (o != null) {
            cb.removeAllItems();
            if (o instanceof Measure) {
                oldMeasure = (Measure)o;
            }
        }
        cb.addItem((Object)"--\u9009\u62e9\u7edf\u8ba1\u5b57\u6bb5--");
        int index = -1;
        for (int i = 0; i < measures.length; ++i) {
            if (measures[i].isMetric) continue;
            cb.addItem((Object)measures[i]);
            if (oldMeasure == null || !measures[i].name.equals(oldMeasure.name)) continue;
            index = i + 1;
        }
    }

    @Override
    public void setDataModel(DataModel2 dataModel) {
        Measure[] measures = dataModel.getMeasures();
        this.loadData(measures, this.cbLeft);
        this.loadData(measures, this.cbRight);
    }

    @Override
    public void setInitMetric(Metric metric) {
        MetricSpec spec = metric.getSpec();
        String left = spec.get("left");
        String right = spec.get("right");
        this.initMeasure(this.cbLeft, left);
        this.initMeasure(this.cbRight, right);
    }

    private void initMeasure(KDComboBox cb, String measureId) {
        for (int i = 1; i < cb.getItemCount(); ++i) {
            Measure measure = (Measure)cb.getItemAt(i);
            if (!measure.getId().equals(measureId)) continue;
            cb.setSelectedIndex(i);
            return;
        }
    }
}

