/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.metric;

import com.kingdee.bos.streamwork.metric.MetricSpec;
import com.kingdee.bos.streamwork.metric.MetricType;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import java.io.Serializable;
import org.jdom2.Element;

public abstract class Metric
implements Serializable {
    protected String name;
    protected String caption;
    protected MetricSpec spec;

    public Metric(String name, String caption, MetricSpec spec) {
        this.name = name;
        this.caption = caption;
        this.spec = spec;
    }

    public String getName() {
        return this.name;
    }

    public String getCaption() {
        return this.caption != null ? this.caption : this.name;
    }

    public MetricSpec getSpec() {
        return this.spec;
    }

    public abstract MetricType getType();

    public abstract String getFormular(QueryModel var1);

    public abstract String getFormatString(int var1);

    public abstract String[] getReference();

    public Element toXML() {
        Element element = new Element("Metric");
        element.setAttribute("name", this.name);
        if (this.caption != null) {
            element.setAttribute("caption", this.caption);
        }
        element.setAttribute("type", this.getType().getName());
        this.getType().getXmlSerde().toElement(this.spec, element);
        return element;
    }

    public static Metric fromXML(Element element) {
        String name = element.getAttributeValue("name");
        String caption = element.getAttributeValue("caption");
        String type = element.getAttributeValue("type");
        MetricType metricType = MetricType.getType(type);
        MetricSpec spec = metricType.getXmlSerde().fromXml(element);
        Metric metric = metricType.createMetric(name, caption, spec);
        return metric;
    }

    protected String quote(String s) {
        return "[" + s + "]";
    }

    protected String quoteMeasure(String measure) {
        return "Measures.[" + measure + "]";
    }
}

