/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.metric;

import com.kingdee.bos.streamwork.metric.AvgMetric;
import com.kingdee.bos.streamwork.metric.AvgMetricUI;
import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.metric.MetricSpec;
import com.kingdee.bos.streamwork.metric.MetricUI;
import com.kingdee.bos.streamwork.metric.PercentMetric;
import com.kingdee.bos.streamwork.metric.PercentMetricUI;
import com.kingdee.bos.streamwork.metric.XmlSerde;
import java.util.ArrayList;
import java.util.HashMap;
import org.jdom2.Element;

public abstract class MetricType {
    private String name;
    private String caption;
    private static ArrayList<MetricType> allType = new ArrayList();
    private static HashMap<String, MetricType> typeMap = new HashMap();
    public static MetricType AVG = new MetricType("Avg", "\u6c47\u603b\u5e73\u5747\u503c"){

        @Override
        public MetricUI createMetricUI() {
            return new AvgMetricUI();
        }

        @Override
        public Metric createMetric(String name, String caption, MetricSpec spec) {
            return new AvgMetric(name, caption, spec);
        }

        @Override
        public XmlSerde getXmlSerde() {
            return new XmlSerde(){

                @Override
                public void toElement(MetricSpec spec, Element ele) {
                    ele.setAttribute("left", spec.get("left"));
                    ele.setAttribute("right", spec.get("right"));
                }

                @Override
                public MetricSpec fromXml(Element ele) {
                    MetricSpec spec = new MetricSpec();
                    spec.put("left", ele.getAttributeValue("left"));
                    spec.put("right", ele.getAttributeValue("right"));
                    return spec;
                }
            };
        }
    };
    public static MetricType PERCENT = new MetricType("Percent", "\u5360\u6bd4"){

        @Override
        public MetricUI createMetricUI() {
            return new PercentMetricUI();
        }

        @Override
        public Metric createMetric(String name, String caption, MetricSpec spec) {
            return new PercentMetric(name, caption, spec);
        }

        @Override
        public XmlSerde getXmlSerde() {
            return new XmlSerde(){

                @Override
                public void toElement(MetricSpec spec, Element ele) {
                    ele.setAttribute("measure", spec.get("measure"));
                    ele.setAttribute("showPercent", spec.get("showPercent"));
                }

                @Override
                public MetricSpec fromXml(Element ele) {
                    MetricSpec spec = new MetricSpec();
                    spec.put("measure", ele.getAttributeValue("measure"));
                    spec.put("showPercent", ele.getAttributeValue("showPercent"));
                    return spec;
                }
            };
        }
    };

    private MetricType(String name, String caption) {
        this.name = name;
        this.caption = caption;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.caption != null ? this.caption : this.name;
    }

    public abstract MetricUI createMetricUI();

    public abstract Metric createMetric(String var1, String var2, MetricSpec var3);

    public abstract XmlSerde getXmlSerde();

    public static void register(MetricType type) {
        allType.add(type);
        typeMap.put(type.getName(), type);
    }

    public static MetricType getType(String name) {
        return typeMap.get(name);
    }

    public static MetricType[] getAllType() {
        return allType.toArray(new MetricType[allType.size()]);
    }

    static {
        MetricType.register(AVG);
        MetricType.register(PERCENT);
    }
}

